/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.cms;

import org.python27.bouncycastle.asn1.ASN1OctetString;
import org.python27.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.python27.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.python27.bouncycastle.asn1.cms.RecipientIdentifier;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.cms.AuthAttributesProvider;
import org.python27.bouncycastle.cms.CMSException;
import org.python27.bouncycastle.cms.CMSSecureReadable;
import org.python27.bouncycastle.cms.KeyTransRecipient;
import org.python27.bouncycastle.cms.KeyTransRecipientId;
import org.python27.bouncycastle.cms.Recipient;
import org.python27.bouncycastle.cms.RecipientInformation;
import org.python27.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

