/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.cms;

import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.cert.X509CertificateHolder;
import org.python27.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.python27.bouncycastle.operator.ContentVerifier;
import org.python27.bouncycastle.operator.ContentVerifierProvider;
import org.python27.bouncycastle.operator.DigestCalculator;
import org.python27.bouncycastle.operator.DigestCalculatorProvider;
import org.python27.bouncycastle.operator.OperatorCreationException;
import org.python27.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;

public class SignerInformationVerifier {
    private ContentVerifierProvider verifierProvider;
    private DigestCalculatorProvider digestProvider;
    private SignatureAlgorithmIdentifierFinder sigAlgorithmFinder;
    private CMSSignatureAlgorithmNameGenerator sigNameGenerator;

    public SignerInformationVerifier(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, ContentVerifierProvider contentVerifierProvider, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigNameGenerator = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgorithmFinder = signatureAlgorithmIdentifierFinder;
        this.verifierProvider = contentVerifierProvider;
        this.digestProvider = digestCalculatorProvider;
    }

    public boolean hasAssociatedCertificate() {
        return this.verifierProvider.hasAssociatedCertificate();
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.verifierProvider.getAssociatedCertificate();
    }

    public ContentVerifier getContentVerifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws OperatorCreationException {
        String string2 = this.sigNameGenerator.getSignatureName(algorithmIdentifier2, algorithmIdentifier);
        AlgorithmIdentifier algorithmIdentifier3 = this.sigAlgorithmFinder.find(string2);
        return this.verifierProvider.get(new AlgorithmIdentifier(algorithmIdentifier3.getAlgorithm(), algorithmIdentifier.getParameters()));
    }

    public DigestCalculator getDigestCalculator(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        return this.digestProvider.get(algorithmIdentifier);
    }
}

