/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.crypto.agreement.kdf;

import java.io.IOException;
import org.python27.bouncycastle.asn1.ASN1EncodableVector;
import org.python27.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python27.bouncycastle.asn1.DERNull;
import org.python27.bouncycastle.asn1.DEROctetString;
import org.python27.bouncycastle.asn1.DERSequence;
import org.python27.bouncycastle.asn1.DERTaggedObject;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.crypto.DataLengthException;
import org.python27.bouncycastle.crypto.DerivationParameters;
import org.python27.bouncycastle.crypto.Digest;
import org.python27.bouncycastle.crypto.DigestDerivationFunction;
import org.python27.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import org.python27.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.python27.bouncycastle.crypto.params.KDFParameters;
import org.python27.bouncycastle.util.Pack;

public class ECDHKEKGenerator
implements DigestDerivationFunction {
    private DigestDerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    public void init(DerivationParameters derivationParameters) {
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        this.algorithm = dHKDFParameters.getAlgorithm();
        this.keySize = dHKDFParameters.getKeySize();
        this.z = dHKDFParameters.getZ();
    }

    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("output buffer too small");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE));
        aSN1EncodableVector.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(aSN1EncodableVector).getEncoded("DER")));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to initialise kdf: " + iOException.getMessage());
        }
        return this.kdf.generateBytes(byArray, n, n2);
    }
}

