/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.crypto.ec;

import org.python27.bouncycastle.crypto.CipherParameters;
import org.python27.bouncycastle.crypto.ec.ECDecryptor;
import org.python27.bouncycastle.crypto.ec.ECPair;
import org.python27.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.python27.bouncycastle.math.ec.ECAlgorithms;
import org.python27.bouncycastle.math.ec.ECCurve;
import org.python27.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public ECPoint decrypt(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECCurve eCCurve = this.key.getParameters().getCurve();
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCCurve, eCPair.getX()).multiply(this.key.getD());
        return ECAlgorithms.cleanPoint(eCCurve, eCPair.getY()).subtract(eCPoint).normalize();
    }
}

