/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import org.python27.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.python27.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.python27.bouncycastle.crypto.KeyGenerationParameters;
import org.python27.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.python27.bouncycastle.crypto.params.Ed25519PublicKeyParameters;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed25519PublicKeyParameters, ed25519PrivateKeyParameters);
    }
}

