/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import org.python27.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.python27.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.python27.bouncycastle.crypto.KeyGenerationParameters;
import org.python27.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.python27.bouncycastle.crypto.params.Ed448PublicKeyParameters;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

