/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.crypto.tls;

import java.io.IOException;
import org.python27.bouncycastle.crypto.tls.DTLSReplayWindow;
import org.python27.bouncycastle.crypto.tls.TlsCipher;
import org.python27.bouncycastle.crypto.tls.TlsFatalAlert;

class DTLSEpoch {
    private final DTLSReplayWindow replayWindow = new DTLSReplayWindow();
    private final int epoch;
    private final TlsCipher cipher;
    private long sequenceNumber = 0L;

    DTLSEpoch(int n, TlsCipher tlsCipher) {
        if (n < 0) {
            throw new IllegalArgumentException("'epoch' must be >= 0");
        }
        if (tlsCipher == null) {
            throw new IllegalArgumentException("'cipher' cannot be null");
        }
        this.epoch = n;
        this.cipher = tlsCipher;
    }

    synchronized long allocateSequenceNumber() throws IOException {
        if (this.sequenceNumber >= 0x1000000000000L) {
            throw new TlsFatalAlert(80);
        }
        return this.sequenceNumber++;
    }

    TlsCipher getCipher() {
        return this.cipher;
    }

    int getEpoch() {
        return this.epoch;
    }

    DTLSReplayWindow getReplayWindow() {
        return this.replayWindow;
    }

    synchronized long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

