/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.crypto.tls;

import java.io.IOException;
import org.python27.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python27.bouncycastle.crypto.params.RSAKeyParameters;
import org.python27.bouncycastle.crypto.tls.AbstractTlsEncryptionCredentials;
import org.python27.bouncycastle.crypto.tls.Certificate;
import org.python27.bouncycastle.crypto.tls.TlsContext;
import org.python27.bouncycastle.crypto.tls.TlsRSAUtils;

public class DefaultTlsEncryptionCredentials
extends AbstractTlsEncryptionCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public DefaultTlsEncryptionCredentials(TlsContext tlsContext, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(asymmetricKeyParameter instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.context = tlsContext;
        this.certificate = certificate;
        this.privateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] decryptPreMasterSecret(byte[] byArray) throws IOException {
        return TlsRSAUtils.safeDecryptPreMasterSecret(this.context, (RSAKeyParameters)this.privateKey, byArray);
    }
}

