/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.dvcs;

import java.io.IOException;
import org.python27.bouncycastle.cms.CMSException;
import org.python27.bouncycastle.cms.CMSProcessableByteArray;
import org.python27.bouncycastle.cms.CMSSignedData;
import org.python27.bouncycastle.cms.CMSSignedDataGenerator;
import org.python27.bouncycastle.dvcs.DVCSException;
import org.python27.bouncycastle.dvcs.DVCSMessage;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

