/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.python27.bouncycastle.asn1.dvcs.Data;
import org.python27.bouncycastle.asn1.dvcs.TargetEtcChain;
import org.python27.bouncycastle.dvcs.DVCSConstructionException;
import org.python27.bouncycastle.dvcs.DVCSRequestData;
import org.python27.bouncycastle.dvcs.TargetChain;

public class VPKCRequestData
extends DVCSRequestData {
    private List chains;

    VPKCRequestData(Data data) throws DVCSConstructionException {
        super(data);
        TargetEtcChain[] targetEtcChainArray = data.getCerts();
        if (targetEtcChainArray == null) {
            throw new DVCSConstructionException("DVCSRequest.data.certs should be specified for VPKC service");
        }
        this.chains = new ArrayList(targetEtcChainArray.length);
        for (int i = 0; i != targetEtcChainArray.length; ++i) {
            this.chains.add(new TargetChain(targetEtcChainArray[i]));
        }
    }

    public List getCerts() {
        return Collections.unmodifiableList(this.chains);
    }
}

