/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.jcajce.provider.digest;

import org.python27.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import org.python27.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.python27.bouncycastle.crypto.CipherKeyGenerator;
import org.python27.bouncycastle.crypto.digests.MD5Digest;
import org.python27.bouncycastle.crypto.macs.HMac;
import org.python27.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.python27.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import org.python27.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import org.python27.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.python27.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class MD5 {
    private MD5() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD5Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new MD5Digest((MD5Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD5Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD5", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD5.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.MD5", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md5, "MD5");
            this.addHMACAlgorithm(configurableProvider, "MD5", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "MD5", IANAObjectIdentifiers.hmacMD5);
        }
    }
}

