/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import org.python27.bouncycastle.asn1.ASN1InputStream;
import org.python27.bouncycastle.asn1.ASN1Primitive;
import org.python27.bouncycastle.asn1.ASN1Sequence;
import org.python27.bouncycastle.util.encoders.Base64;

public class PEMUtil {
    private final String _header1;
    private final String _header2;
    private final String _footer1;
    private final String _footer2;

    PEMUtil(String string2) {
        this._header1 = "-----BEGIN " + string2 + "-----";
        this._header2 = "-----BEGIN X509 " + string2 + "-----";
        this._footer1 = "-----END " + string2 + "-----";
        this._footer2 = "-----END X509 " + string2 + "-----";
    }

    private String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if ((n = inputStream.read()) != 13 && n != 10 && n >= 0) {
                if (n == 13) continue;
                stringBuffer.append((char)n);
                continue;
            }
            if (n < 0 || stringBuffer.length() != 0) break;
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    ASN1Sequence readPEMObject(InputStream inputStream) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = this.readLine(inputStream)) != null && !string2.startsWith(this._header1) && !string2.startsWith(this._header2)) {
        }
        while ((string2 = this.readLine(inputStream)) != null && !string2.startsWith(this._footer1) && !string2.startsWith(this._footer2)) {
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() != 0) {
            ASN1Primitive aSN1Primitive = new ASN1InputStream(Base64.decode(stringBuffer.toString())).readObject();
            if (!(aSN1Primitive instanceof ASN1Sequence)) {
                throw new IOException("malformed PEM data encountered");
            }
            return (ASN1Sequence)aSN1Primitive;
        }
        return null;
    }
}

