/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.python27.bouncycastle.mime.LineReader;
import org.python27.bouncycastle.util.Iterable;
import org.python27.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headers
implements Iterable<String> {
    private final Map<String, List> headers = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
    private final List<String> headersAsPresented;
    private final String contentTransferEncoding;
    private String boundary;
    private boolean multipart;
    private String contentType;
    private Map<String, String> contentTypeParameters;

    private static List<String> parseHeaders(InputStream inputStream) throws IOException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        LineReader lineReader = new LineReader(inputStream);
        while ((string2 = lineReader.readLine()) != null && string2.length() != 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Headers(InputStream inputStream, String string2) throws IOException {
        this(Headers.parseHeaders(inputStream), string2);
    }

    public Headers(List<String> list, String string2) {
        int n;
        this.headersAsPresented = list;
        String string3 = "";
        Object object = list.iterator();
        while (object.hasNext()) {
            String string4 = object.next();
            if (string4.startsWith(" ") || string4.startsWith("\t")) {
                string3 = string3 + string4.trim();
                continue;
            }
            if (string3.length() != 0) {
                this.put(string3.substring(0, string3.indexOf(58)).trim(), string3.substring(string3.indexOf(58) + 1).trim());
            }
            string3 = string4;
        }
        if (string3.trim().length() != 0) {
            this.put(string3.substring(0, string3.indexOf(58)).trim(), string3.substring(string3.indexOf(58) + 1).trim());
        }
        if ((n = ((String)(object = this.getValues("Content-Type") == null ? "text/plain" : this.getValues("Content-Type")[0])).indexOf(59)) < 0) {
            this.contentType = object;
            this.contentTypeParameters = Collections.EMPTY_MAP;
        } else {
            this.contentType = ((String)object).substring(0, n);
            this.contentTypeParameters = this.createContentTypeParameters(((String)object).substring(n + 1).trim());
        }
        String string5 = this.contentTransferEncoding = this.getValues("Content-Transfer-Encoding") == null ? string2 : this.getValues("Content-Transfer-Encoding")[0];
        if (this.contentType.indexOf("multipart") >= 0) {
            this.multipart = true;
            String string6 = this.contentTypeParameters.get("boundary");
            this.boundary = string6.substring(1, string6.length() - 1);
        } else {
            this.boundary = null;
            this.multipart = false;
        }
    }

    public Map<String, String> getContentTypeAttributes() {
        return this.contentTypeParameters;
    }

    private Map<String, String> createContentTypeParameters(String string2) {
        String[] stringArray = string2.split(";");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i != stringArray.length; ++i) {
            String string3 = stringArray[i];
            int n = string3.indexOf(61);
            if (n < 0) {
                throw new IllegalArgumentException("malformed Content-Type header");
            }
            linkedHashMap.put(string3.substring(0, n).trim(), string3.substring(n + 1).trim());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String string2, String string3) {
        Headers headers2 = this;
        synchronized (headers2) {
            KV kV = new KV(string2, string3);
            ArrayList<KV> arrayList = this.headers.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<KV>();
                this.headers.put(string2, arrayList);
            }
            arrayList.add(kV);
        }
    }

    public Iterator<String> getNames() {
        return this.headers.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValues(String string2) {
        Headers headers2 = this;
        synchronized (headers2) {
            List list = this.headers.get(string2);
            if (list == null) {
                return null;
            }
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = ((KV)list.get((int)i)).value;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Headers headers2 = this;
        synchronized (headers2) {
            return this.headers.isEmpty();
        }
    }

    public boolean containsKey(String string2) {
        return this.headers.containsKey(string2);
    }

    @Override
    public Iterator<String> iterator() {
        return this.headers.keySet().iterator();
    }

    public void dumpHeaders(OutputStream outputStream) throws IOException {
        Iterator<String> iterator = this.headersAsPresented.iterator();
        while (iterator.hasNext()) {
            outputStream.write(Strings.toUTF8ByteArray(iterator.next().toString()));
            outputStream.write(13);
            outputStream.write(10);
        }
    }

    private class KV {
        public final String key;
        public final String value;

        public KV(String string2, String string3) {
            this.key = string2;
            this.value = string3;
        }

        public KV(KV kV) {
            this.key = kV.key;
            this.value = kV.value;
        }
    }
}

