/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.mime.encoding;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private static final byte[] decodingTable;
    InputStream in;
    int[] outBuf = new int[3];
    int bufPtr = 3;
    boolean isEndOfStream;

    private int decode(int n, int n2, int n3, int n4, int[] nArray) throws EOFException {
        if (n4 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (n3 == 61) {
            int n5 = decodingTable[n] & 0xFF;
            int n6 = decodingTable[n2] & 0xFF;
            nArray[2] = (n5 << 2 | n6 >> 4) & 0xFF;
            return 2;
        }
        if (n4 == 61) {
            byte by = decodingTable[n];
            byte by2 = decodingTable[n2];
            byte by3 = decodingTable[n3];
            nArray[1] = (by << 2 | by2 >> 4) & 0xFF;
            nArray[2] = (by2 << 4 | by3 >> 2) & 0xFF;
            return 1;
        }
        byte by = decodingTable[n];
        byte by4 = decodingTable[n2];
        byte by5 = decodingTable[n3];
        byte by6 = decodingTable[n4];
        nArray[0] = (by << 2 | by4 >> 4) & 0xFF;
        nArray[1] = (by4 << 4 | by5 >> 2) & 0xFF;
        nArray[2] = (by5 << 6 | by6) & 0xFF;
        return 0;
    }

    public Base64InputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    private int readIgnoreSpace() throws IOException {
        int n = this.in.read();
        while (n == 32 || n == 9) {
            n = this.in.read();
        }
        return n;
    }

    public int read() throws IOException {
        int n;
        if (this.bufPtr > 2) {
            n = this.readIgnoreSpace();
            if (n == 13 || n == 10) {
                n = this.readIgnoreSpace();
                while (n == 10 || n == 13) {
                    n = this.readIgnoreSpace();
                }
                if (n < 0) {
                    this.isEndOfStream = true;
                    return -1;
                }
                this.bufPtr = this.decode(n, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else if (n >= 0) {
                this.bufPtr = this.decode(n, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else {
                this.isEndOfStream = true;
                return -1;
            }
        }
        n = this.outBuf[this.bufPtr++];
        return n;
    }

    public void close() throws IOException {
        this.in.close();
    }

    static {
        int n;
        decodingTable = new byte[128];
        for (n = 65; n <= 90; ++n) {
            Base64InputStream.decodingTable[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            Base64InputStream.decodingTable[n] = (byte)(n - 97 + 26);
        }
        for (n = 48; n <= 57; ++n) {
            Base64InputStream.decodingTable[n] = (byte)(n - 48 + 52);
        }
        Base64InputStream.decodingTable[43] = 62;
        Base64InputStream.decodingTable[47] = 63;
    }
}

