/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.operator.bc;

import org.python27.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python27.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.crypto.AsymmetricBlockCipher;
import org.python27.bouncycastle.crypto.InvalidCipherTextException;
import org.python27.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python27.bouncycastle.operator.AsymmetricKeyUnwrapper;
import org.python27.bouncycastle.operator.GenericKey;
import org.python27.bouncycastle.operator.OperatorException;

public abstract class BcAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private AsymmetricKeyParameter privateKey;

    public BcAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier);
        this.privateKey = asymmetricKeyParameter;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createAsymmetricUnwrapper(this.getAlgorithmIdentifier().getAlgorithm());
        asymmetricBlockCipher.init(false, this.privateKey);
        try {
            byte[] byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
            if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.des_EDE3_CBC)) {
                return new GenericKey(algorithmIdentifier, byArray2);
            }
            return new GenericKey(algorithmIdentifier, byArray2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to recover secret key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricUnwrapper(ASN1ObjectIdentifier var1);
}

