/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.operator.bc;

import java.security.SecureRandom;
import org.python27.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.crypto.AsymmetricBlockCipher;
import org.python27.bouncycastle.crypto.CipherParameters;
import org.python27.bouncycastle.crypto.InvalidCipherTextException;
import org.python27.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python27.bouncycastle.crypto.params.ParametersWithRandom;
import org.python27.bouncycastle.operator.AsymmetricKeyWrapper;
import org.python27.bouncycastle.operator.GenericKey;
import org.python27.bouncycastle.operator.OperatorException;
import org.python27.bouncycastle.operator.bc.OperatorUtils;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier);
        this.publicKey = asymmetricKeyParameter;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters cipherParameters = this.publicKey;
        if (this.random != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
        }
        try {
            byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
            asymmetricBlockCipher.init(true, cipherParameters);
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to encrypt contents key", invalidCipherTextException);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

