/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.operator.bc;

import java.io.IOException;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.python27.bouncycastle.crypto.ExtendedDigest;
import org.python27.bouncycastle.crypto.Signer;
import org.python27.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python27.bouncycastle.crypto.signers.DSADigestSigner;
import org.python27.bouncycastle.crypto.signers.ECDSASigner;
import org.python27.bouncycastle.crypto.util.PublicKeyFactory;
import org.python27.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.python27.bouncycastle.operator.OperatorCreationException;
import org.python27.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new ECDSASigner(), extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

