/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.operator.bc;

import java.security.SecureRandom;
import org.python27.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python27.bouncycastle.crypto.InvalidCipherTextException;
import org.python27.bouncycastle.crypto.Wrapper;
import org.python27.bouncycastle.crypto.params.KeyParameter;
import org.python27.bouncycastle.operator.GenericKey;
import org.python27.bouncycastle.operator.OperatorException;
import org.python27.bouncycastle.operator.SymmetricKeyUnwrapper;

public class BcSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyUnwrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        this.wrapper.init(false, this.wrappingKey);
        try {
            return new GenericKey(algorithmIdentifier, this.wrapper.unwrap(byArray, 0, byArray.length));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }
}

