/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.pqc.crypto.xmss;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.python27.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python27.bouncycastle.pqc.crypto.xmss.BDS;
import org.python27.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.python27.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.python27.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.python27.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.python27.bouncycastle.util.Integers;

public class BDSStateMap
implements Serializable {
    private static final long serialVersionUID = -3464451825208522308L;
    private final Map<Integer, BDS> bdsState = new TreeMap<Integer, BDS>();

    BDSStateMap() {
    }

    BDSStateMap(XMSSMTParameters xMSSMTParameters, long l, byte[] byArray, byte[] byArray2) {
        for (long i = 0L; i < l; ++i) {
            this.updateState(xMSSMTParameters, i, byArray, byArray2);
        }
    }

    BDSStateMap(BDSStateMap bDSStateMap, XMSSMTParameters xMSSMTParameters, long l, byte[] byArray, byte[] byArray2) {
        for (Integer n : bDSStateMap.bdsState.keySet()) {
            this.bdsState.put(n, bDSStateMap.bdsState.get(n));
        }
        this.updateState(xMSSMTParameters, l, byArray, byArray2);
    }

    private void updateState(XMSSMTParameters xMSSMTParameters, long l, byte[] byArray, byte[] byArray2) {
        XMSSParameters xMSSParameters = xMSSMTParameters.getXMSSParameters();
        int n = xMSSParameters.getHeight();
        long l2 = XMSSUtil.getTreeIndex(l, n);
        int n2 = XMSSUtil.getLeafIndex(l, n);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l2)).withOTSAddress(n2).build();
        if (n2 < (1 << n) - 1) {
            if (this.get(0) == null || n2 == 0) {
                this.put(0, new BDS(xMSSParameters, byArray, byArray2, oTSHashAddress));
            }
            this.update(0, byArray, byArray2, oTSHashAddress);
        }
        for (int i = 1; i < xMSSMTParameters.getLayers(); ++i) {
            n2 = XMSSUtil.getLeafIndex(l2, n);
            l2 = XMSSUtil.getTreeIndex(l2, n);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i)).withTreeAddress(l2)).withOTSAddress(n2).build();
            if (n2 >= (1 << n) - 1 || !XMSSUtil.isNewAuthenticationPathNeeded(l, n, i)) continue;
            if (this.get(i) == null) {
                this.put(i, new BDS(xMSSMTParameters.getXMSSParameters(), byArray, byArray2, oTSHashAddress));
            }
            this.update(i, byArray, byArray2, oTSHashAddress);
        }
    }

    public boolean isEmpty() {
        return this.bdsState.isEmpty();
    }

    BDS get(int n) {
        return this.bdsState.get(Integers.valueOf(n));
    }

    BDS update(int n, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        return this.bdsState.put(Integers.valueOf(n), this.bdsState.get(Integers.valueOf(n)).getNextState(byArray, byArray2, oTSHashAddress));
    }

    void put(int n, BDS bDS) {
        this.bdsState.put(Integers.valueOf(n), bDS);
    }

    public BDSStateMap withWOTSDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        BDSStateMap bDSStateMap = new BDSStateMap();
        for (Integer n : this.bdsState.keySet()) {
            bDSStateMap.bdsState.put(n, this.bdsState.get(n).withWOTSDigest(aSN1ObjectIdentifier));
        }
        return bDSStateMap;
    }
}

