/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.pqc.jcajce.provider.qtesla;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.python27.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.python27.bouncycastle.crypto.CryptoServicesRegistrar;
import org.python27.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import org.python27.bouncycastle.pqc.crypto.qtesla.QTESLAKeyPairGenerator;
import org.python27.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.python27.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import org.python27.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import org.python27.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPrivateKey;
import org.python27.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPublicKey;
import org.python27.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import org.python27.bouncycastle.util.Integers;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final Map catLookup = new HashMap();
    private QTESLAKeyGenerationParameters param;
    private QTESLAKeyPairGenerator engine = new QTESLAKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("qTESLA");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof QTESLAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a QTESLAParameterSpec");
        }
        QTESLAParameterSpec qTESLAParameterSpec = (QTESLAParameterSpec)algorithmParameterSpec;
        this.param = new QTESLAKeyGenerationParameters((Integer)catLookup.get(qTESLAParameterSpec.getSecurityCategory()), secureRandom);
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new QTESLAKeyGenerationParameters(3, this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        QTESLAPublicKeyParameters qTESLAPublicKeyParameters = (QTESLAPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters = (QTESLAPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCqTESLAPublicKey(qTESLAPublicKeyParameters), new BCqTESLAPrivateKey(qTESLAPrivateKeyParameters));
    }

    static {
        catLookup.put(QTESLASecurityCategory.getName(0), Integers.valueOf(0));
        catLookup.put(QTESLASecurityCategory.getName(1), Integers.valueOf(1));
        catLookup.put(QTESLASecurityCategory.getName(2), Integers.valueOf(2));
        catLookup.put(QTESLASecurityCategory.getName(3), Integers.valueOf(3));
        catLookup.put(QTESLASecurityCategory.getName(4), Integers.valueOf(4));
    }
}

