/*
 * Decompiled with CFR 0.152.
 */
package org.python27.bouncycastle.util;

import java.math.BigInteger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.python27.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    private static final ThreadLocal threadProperties = new ThreadLocal();

    private Properties() {
    }

    public static boolean isOverrideSet(String string2) {
        try {
            String string3 = Properties.fetchProperty(string2);
            if (string3 != null) {
                return "true".equals(Strings.toLowerCase(string3));
            }
            return false;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean setThreadOverride(String string2, boolean bl) {
        boolean bl2 = Properties.isOverrideSet(string2);
        HashMap<String, String> hashMap = (HashMap<String, String>)threadProperties.get();
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        hashMap.put(string2, bl ? "true" : "false");
        threadProperties.set(hashMap);
        return bl2;
    }

    public static boolean removeThreadOverride(String string2) {
        boolean bl = Properties.isOverrideSet(string2);
        Map map = (Map)threadProperties.get();
        if (map == null) {
            return false;
        }
        map.remove(string2);
        if (map.isEmpty()) {
            threadProperties.remove();
        } else {
            threadProperties.set(map);
        }
        return bl;
    }

    public static BigInteger asBigInteger(String string2) {
        String string3 = Properties.fetchProperty(string2);
        if (string3 != null) {
            return new BigInteger(string3);
        }
        return null;
    }

    public static Set<String> asKeySet(String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = Properties.fetchProperty(string2);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(Strings.toLowerCase(stringTokenizer.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static String fetchProperty(final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map map = (Map)threadProperties.get();
                if (map != null) {
                    return map.get(string2);
                }
                return System.getProperty(string2);
            }
        });
    }
}

