/*
 * Decompiled with CFR 0.152.
 */
package org.python27.compiler;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.python27.antlr.ParseException;
import org.python27.antlr.ast.Expr;
import org.python27.antlr.ast.ImportFrom;
import org.python27.antlr.ast.Interactive;
import org.python27.antlr.ast.Module;
import org.python27.antlr.ast.Str;
import org.python27.antlr.ast.alias;
import org.python27.antlr.base.mod;
import org.python27.antlr.base.stmt;
import org.python27.core.CodeFlag;
import org.python27.core.CompilerFlags;
import org.python27.core.FutureFeature;
import org.python27.core.Pragma;
import org.python27.core.PragmaReceiver;

public class Future {
    Set<FutureFeature> featureSet = EnumSet.noneOf(FutureFeature.class);
    private final PragmaReceiver features = new PragmaReceiver(){

        @Override
        public void add(Pragma pragma) {
            if (pragma instanceof FutureFeature) {
                FutureFeature feature = (FutureFeature)pragma;
                Future.this.featureSet.add(feature);
            }
        }
    };

    private boolean check(ImportFrom cand) throws Exception {
        if (!cand.getInternalModule().equals("__future__")) {
            return false;
        }
        if (cand.getInternalNames().isEmpty()) {
            throw new ParseException("future statement does not support import *", cand);
        }
        try {
            for (alias feature : cand.getInternalNames()) {
                FutureFeature.addFeature(feature.getInternalName(), this.features);
            }
        }
        catch (ParseException pe) {
            throw new ParseException(pe.getMessage(), cand);
        }
        return true;
    }

    public void preprocessFutures(mod node, CompilerFlags cflags) throws Exception {
        stmt s;
        if (cflags != null) {
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                FutureFeature.division.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_WITH_STATEMENT)) {
                FutureFeature.with_statement.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_ABSOLUTE_IMPORT)) {
                FutureFeature.absolute_import.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_PRINT_FUNCTION)) {
                FutureFeature.print_function.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_UNICODE_LITERALS)) {
                FutureFeature.unicode_literals.addTo(this.features);
            }
        }
        int beg = 0;
        List<stmt> suite2 = null;
        if (node instanceof Module) {
            suite2 = ((Module)node).getInternalBody();
            if (suite2.size() > 0 && suite2.get(0) instanceof Expr && ((Expr)suite2.get(0)).getInternalValue() instanceof Str) {
                ++beg;
            }
        } else if (node instanceof Interactive) {
            suite2 = ((Interactive)node).getInternalBody();
        } else {
            return;
        }
        for (int i = beg; i < suite2.size() && (s = suite2.get(i)) instanceof ImportFrom; ++i) {
            s.from_future_checked = true;
            if (!this.check((ImportFrom)s)) break;
        }
        if (cflags != null) {
            for (FutureFeature feature : this.featureSet) {
                feature.setFlag(cflags);
            }
        }
    }

    public static void checkFromFuture(ImportFrom node) throws Exception {
        if (node.from_future_checked) {
            return;
        }
        if (node.getInternalModule().equals("__future__")) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", node);
        }
        node.from_future_checked = true;
    }

    public boolean areDivisionOn() {
        return this.featureSet.contains(FutureFeature.division);
    }

    public boolean withStatementSupported() {
        return this.featureSet.contains(FutureFeature.with_statement);
    }

    public boolean isAbsoluteImportOn() {
        return this.featureSet.contains(FutureFeature.absolute_import);
    }
}

