/*
 * Decompiled with CFR 0.152.
 */
package org.python27.compiler;

import java.lang.reflect.Array;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.python27.compiler.APIVersion;
import org.python27.compiler.MTime;
import org.python27.core.ClassDictInit;
import org.python27.core.PyObject;
import org.python27.core.PyProxy;
import org.python27.core.PySystemState;
import org.python27.util.PythonInterpreter;

public class JavaMakerSmokeTest {
    public PythonInterpreter interp;
    public Class<?> proxyClass;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties(System.getProperties());
        props.setProperty("python.cachedir.skip", "true");
        PySystemState.initialize(props, null);
        this.interp = new PythonInterpreter();
        String input = new String();
        input = input + "import java.io.ByteArrayInputStream\n";
        input = input + "import java.lang.String\n";
        input = input + "import org.python27.core.Options\n";
        input = input + "org.python27.core.Options.proxyDebugDirectory = 'build/classes'\n";
        input = input + "class ProxyTest(java.io.ByteArrayInputStream):\n";
        input = input + "    def somemethod(self): pass\n";
        input = input + "ProxyTest(java.lang.String('teststr').getBytes())\n";
        this.interp.exec(input);
        this.proxyClass = Class.forName("org.python27.proxies.__main__$ProxyTest$0");
    }

    @Test
    public void constructors() throws Exception {
        this.proxyClass.getConstructor(Array.newInstance(Byte.TYPE, 0).getClass());
        this.proxyClass.getConstructor(Array.newInstance(Byte.TYPE, 0).getClass(), Integer.TYPE, Integer.TYPE);
    }

    @Test
    public void methods() throws Exception {
        this.proxyClass.getMethod("classDictInit", PyObject.class);
        this.proxyClass.getMethod("close", new Class[0]);
    }

    @Test
    public void annotations() throws Exception {
        this.proxyClass.getAnnotation(APIVersion.class);
        this.proxyClass.getAnnotation(MTime.class);
    }

    @Test
    public void interfaces() throws Exception {
        Object[] interfaces = new Class[]{PyProxy.class, ClassDictInit.class};
        Assert.assertArrayEquals((Object[])interfaces, (Object[])this.proxyClass.getInterfaces());
    }
}

