/*
 * Decompiled with CFR 0.152.
 */
package org.python27.compiler;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.python27.antlr.ParseException;
import org.python27.antlr.PythonTree;
import org.python27.antlr.ast.Num;
import org.python27.antlr.ast.Str;
import org.python27.antlr.base.mod;
import org.python27.compiler.ClassConstants;
import org.python27.compiler.ClassFile;
import org.python27.compiler.Code;
import org.python27.compiler.CodeCompiler;
import org.python27.compiler.CompilationContext;
import org.python27.compiler.Constant;
import org.python27.compiler.Future;
import org.python27.compiler.PyBytecodeConstant;
import org.python27.compiler.PyCodeConstant;
import org.python27.compiler.PyComplexConstant;
import org.python27.compiler.PyFloatConstant;
import org.python27.compiler.PyIntegerConstant;
import org.python27.compiler.PyLongConstant;
import org.python27.compiler.PyStringConstant;
import org.python27.compiler.PyUnicodeConstant;
import org.python27.compiler.ScopeInfo;
import org.python27.compiler.ScopesCompiler;
import org.python27.core.CodeBootstrap;
import org.python27.core.CodeLoader;
import org.python27.core.CompilerFlags;
import org.python27.core.ContainsPyBytecode;
import org.python27.core.Py;
import org.python27.core.PyBytecode;
import org.python27.core.PyCode;
import org.python27.core.PyComplex;
import org.python27.core.PyException;
import org.python27.core.PyFile;
import org.python27.core.PyFloat;
import org.python27.core.PyFrame;
import org.python27.core.PyFunctionTable;
import org.python27.core.PyInteger;
import org.python27.core.PyLong;
import org.python27.core.PyObject;
import org.python27.core.PyRunnable;
import org.python27.core.PyRunnableBootstrap;
import org.python27.core.PyString;
import org.python27.core.PyUnicode;
import org.python27.core.ThreadState;
import org.python27.core.imp;
import org.python27.modules._marshal;
import org.python27.objectweb.asm.Label;
import org.python27.objectweb.asm.MethodTooLargeException;
import org.python27.objectweb.asm.Opcodes;
import org.python27.objectweb.asm.Type;
import org.python27.util.CodegenUtils;

public class Module
implements Opcodes,
ClassConstants,
CompilationContext {
    ClassFile classfile;
    Constant filename;
    String sfilename;
    Constant mainCode;
    boolean linenumbers;
    Future futures;
    Hashtable<PythonTree, ScopeInfo> scopes;
    List<PyCodeConstant> codes;
    long mtime;
    private int setter_count = 0;
    private static final int USE_SETTERS_LIMIT = 100;
    private static final int MAX_SETTINGS_PER_SETTER = 4096;
    Hashtable<Constant, Constant> constants;
    protected Hashtable<String, String> oversized_methods = null;
    private static String TRIED_CREATE_PYC_MSG = "\nJython tried to create a pyc-file by executing\n    %s\nwhich failed because %s";
    private static String LARGE_METHOD_MSG = "Module or method too large in `%s`.";
    private static String PLEASE_PROVIDE_MSG = "\n\nPlease provide a CPython 2.7 bytecode file (.pyc), e.g. run\n    python -m py_compile %s";
    private static String CPYTHON_CMD_MSG = "\n\nAlternatively, specify a CPython 2.7 command via the python.cpython2 property, e.g.:\n    jython -Dpython.cpython2=python\nor (e.g. for pip) through the environment variable JYTHON_OPTS:\n    export JYTHON_OPTS=\"-Dpython.cpython2=python\"\n";
    private static final char[] base64enc = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int maxLiteral = 65535;

    public Module(String name, String filename, boolean linenumbers) {
        this(name, filename, linenumbers, -1L);
    }

    public Module(String name, String filename, boolean linenumbers, long mtime) {
        this.linenumbers = linenumbers;
        this.mtime = mtime;
        this.classfile = new ClassFile(name, CodegenUtils.p(PyFunctionTable.class), 33, mtime);
        this.constants = new Hashtable();
        this.sfilename = filename;
        this.filename = filename != null ? this.stringConstant(filename) : null;
        this.codes = new ArrayList<PyCodeConstant>();
        this.futures = new Future();
        this.scopes = new Hashtable();
    }

    public Module(String name) {
        this(name, name + ".py", true, -1L);
    }

    private Constant findConstant(Constant c) {
        Constant ret = this.constants.get(c);
        if (ret != null) {
            return ret;
        }
        ret = c;
        c.module = this;
        c.name = "_" + this.constants.size();
        this.constants.put(ret, ret);
        return ret;
    }

    Constant integerConstant(int value) {
        return this.findConstant(new PyIntegerConstant(value));
    }

    Constant floatConstant(double value) {
        return this.findConstant(new PyFloatConstant(value));
    }

    Constant complexConstant(double value) {
        return this.findConstant(new PyComplexConstant(value));
    }

    Constant stringConstant(String value) {
        return this.findConstant(new PyStringConstant(value));
    }

    Constant unicodeConstant(String value) {
        return this.findConstant(new PyUnicodeConstant(value));
    }

    Constant longConstant(String value) {
        return this.findConstant(new PyLongConstant(value));
    }

    Constant codeConstant(mod tree, String name, boolean fast_locals, String className, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        return this.codeConstant(tree, name, fast_locals, className, null, classBody, printResults, firstlineno, scope, cflags);
    }

    Constant codeConstant(mod tree, String name, boolean fast_locals, String className, Str classDoc, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        if (this.oversized_methods != null && this.oversized_methods.containsKey(name + firstlineno)) {
            PyBytecodeConstant bcode = new PyBytecodeConstant(this.oversized_methods.get(name + firstlineno), className, cflags, this);
            this.classfile.addField(bcode.name, CodegenUtils.ci(PyCode.class), 9);
            return bcode;
        }
        PyCodeConstant code2 = new PyCodeConstant(tree, name, fast_locals, className, classBody, printResults, firstlineno, scope, cflags, this);
        this.codes.add(code2);
        CodeCompiler compiler = new CodeCompiler(this, printResults);
        Code c = this.classfile.addMethod(code2.fname, CodegenUtils.sig(PyObject.class, PyFrame.class, ThreadState.class), 1);
        compiler.parse(tree, c, fast_locals, className, classDoc, classBody, scope, cflags);
        return code2;
    }

    public void addInit() throws IOException {
        Code c = this.classfile.addMethod("<init>", CodegenUtils.sig(Void.TYPE, String.class), 1);
        c.aload(0);
        c.invokespecial(CodegenUtils.p(PyFunctionTable.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        this.addConstants(c);
    }

    public void addRunnable() throws IOException {
        Code c = this.classfile.addMethod("getMain", CodegenUtils.sig(PyCode.class, new Class[0]), 1);
        this.mainCode.get(c);
        c.areturn();
    }

    public void addMain() throws IOException {
        Code c = this.classfile.addMethod("main", CodegenUtils.sig(Void.TYPE, String[].class), 9);
        c.new_(this.classfile.name);
        c.dup();
        c.ldc(this.classfile.name);
        c.invokespecial(this.classfile.name, "<init>", CodegenUtils.sig(Void.TYPE, String.class));
        c.invokevirtual(this.classfile.name, "getMain", CodegenUtils.sig(PyCode.class, new Class[0]));
        c.invokestatic(CodegenUtils.p(CodeLoader.class), "createSimpleBootstrap", CodegenUtils.sig(CodeBootstrap.class, PyCode.class));
        c.aload(0);
        c.invokestatic(CodegenUtils.p(Py.class), "runMain", CodegenUtils.sig(Void.TYPE, CodeBootstrap.class, String[].class));
        c.return_();
    }

    public void addBootstrap() throws IOException {
        Code c = this.classfile.addMethod("getCodeBootstrap", CodegenUtils.sig(CodeBootstrap.class, new Class[0]), 9);
        c.ldc(Type.getType("L" + this.classfile.name + ";"));
        c.invokestatic(CodegenUtils.p(PyRunnableBootstrap.class), "getFilenameConstructorReflectionBootstrap", CodegenUtils.sig(CodeBootstrap.class, Class.class));
        c.areturn();
    }

    void addConstants(Code c) throws IOException {
        this.classfile.addField("self", "L" + this.classfile.name + ";", 8);
        c.aload(0);
        c.putstatic(this.classfile.name, "self", "L" + this.classfile.name + ";");
        Enumeration<Constant> e = this.constants.elements();
        while (e.hasMoreElements()) {
            Constant constant = e.nextElement();
            constant.put(c);
        }
        for (PyCodeConstant pyc : this.codes) {
            pyc.put(c);
        }
        c.return_();
    }

    public void addFunctions() throws IOException {
        Code code2 = this.classfile.addMethod("call_function", CodegenUtils.sig(PyObject.class, Integer.TYPE, PyFrame.class, ThreadState.class), 1);
        if (!this.codes.isEmpty()) {
            int i;
            code2.aload(0);
            code2.aload(2);
            code2.aload(3);
            Label def = new Label();
            Label[] labels = new Label[this.codes.size()];
            for (i = 0; i < labels.length; ++i) {
                labels[i] = new Label();
            }
            code2.iload(1);
            code2.tableswitch(0, labels.length - 1, def, labels);
            for (i = 0; i < labels.length; ++i) {
                code2.label(labels[i]);
                code2.invokevirtual(this.classfile.name, this.codes.get((int)i).fname, CodegenUtils.sig(PyObject.class, PyFrame.class, ThreadState.class));
                code2.areturn();
            }
            code2.label(def);
        }
        code2.aconst_null();
        code2.areturn();
    }

    public void write(OutputStream stream) throws IOException {
        this.addInit();
        this.addRunnable();
        this.addMain();
        this.addBootstrap();
        this.addFunctions();
        this.classfile.addInterface(CodegenUtils.p(PyRunnable.class));
        if (this.sfilename != null) {
            this.classfile.setSource(this.sfilename);
        }
        this.classfile.write(stream);
    }

    @Override
    public Future getFutures() {
        return this.futures;
    }

    @Override
    public String getFilename() {
        return this.sfilename;
    }

    @Override
    public ScopeInfo getScopeInfo(PythonTree node) {
        return this.scopes.get(node);
    }

    @Override
    public void error(String msg2, boolean err, PythonTree node) throws Exception {
        block3: {
            if (!err) {
                try {
                    Py.warning(Py.SyntaxWarning, msg2, this.sfilename != null ? this.sfilename : "?", node.getLineno(), null, Py.None);
                    return;
                }
                catch (PyException e) {
                    if (e.match(Py.SyntaxWarning)) break block3;
                    throw e;
                }
            }
        }
        throw new ParseException(msg2, node);
    }

    public static void compile(mod node, OutputStream ostream, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags) throws Exception {
        Module.compile(node, ostream, name, filename, linenumbers, printResults, cflags, -1L);
    }

    protected static void _module_init(mod node, Module module, boolean printResults, CompilerFlags cflags) throws Exception {
        Constant main2;
        if (cflags == null) {
            cflags = new CompilerFlags();
        }
        module.futures.preprocessFutures(node, cflags);
        new ScopesCompiler(module, module.scopes).parse(node);
        module.mainCode = main2 = module.codeConstant(node, "<module>", false, null, false, printResults, 0, module.getScopeInfo(node), cflags);
    }

    private static PyBytecode loadPyBytecode(String filename, boolean try_cpython) throws RuntimeException {
        String pyc_filename;
        File pyc_file;
        if (filename.startsWith("__pyclasspath__/")) {
            URL py_url;
            ClassLoader cld = Py.getSystemState().getClassLoader();
            if (cld == null) {
                cld = imp.getParentClassLoader();
            }
            if ((py_url = cld.getResource(filename.replace("__pyclasspath__/", ""))) != null) {
                filename = py_url.getPath();
            } else {
                throw new RuntimeException(String.format(LARGE_METHOD_MSG, filename) + "but couldn't resolve that filename within classpath.\nMake sure the source file is at a proper location.");
            }
        }
        if ((pyc_file = new File(pyc_filename = filename + "c")).exists()) {
            PyFile f = new PyFile(pyc_filename, "rb", 4096);
            byte[] bts = f.read(8).toBytes();
            int magic = bts[1] << 8 & 0xFF00 | bts[0] << 0 & 0xFF;
            if (magic != 62211) {
                throw new RuntimeException(String.format(LARGE_METHOD_MSG, filename) + "\n'" + pyc_filename + "' is not CPython 2.7 bytecode." + String.format(PLEASE_PROVIDE_MSG, filename));
            }
            _marshal.Unmarshaller un = new _marshal.Unmarshaller(f);
            PyObject code2 = un.load();
            f.close();
            if (code2 instanceof PyBytecode) {
                return (PyBytecode)code2;
            }
            throw new RuntimeException(String.format(LARGE_METHOD_MSG, filename) + "\n'" + pyc_filename + "' contains invalid bytecode." + String.format(PLEASE_PROVIDE_MSG, filename));
        }
        String CPython_command = System.getProperty("python.cpython2");
        if (try_cpython && CPython_command != null) {
            Process p;
            String command_ver = CPython_command + " --version";
            String command = CPython_command + " -m py_compile " + filename;
            Exception exc = null;
            int result2 = 0;
            try {
                p = Runtime.getRuntime().exec(command_ver);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String cp_version = br.readLine();
                while (br.readLine() != null) {
                }
                br.close();
                if (cp_version == null) {
                    br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    cp_version = br.readLine();
                    while (br.readLine() != null) {
                    }
                    br.close();
                }
                result2 = p.waitFor();
                if (!cp_version.startsWith("Python 2.7.")) {
                    String reason = cp_version + " has been provided, but 2.7.x is required.";
                    throw new RuntimeException(String.format(LARGE_METHOD_MSG, filename) + String.format(TRIED_CREATE_PYC_MSG, command, reason) + String.format(PLEASE_PROVIDE_MSG, filename) + CPYTHON_CMD_MSG);
                }
            }
            catch (IOException | InterruptedException e) {
                exc = e;
            }
            if (exc == null && result2 == 0) {
                try {
                    p = Runtime.getRuntime().exec(command);
                    result2 = p.waitFor();
                    if (result2 == 0) {
                        return Module.loadPyBytecode(filename, false);
                    }
                }
                catch (IOException | InterruptedException e) {
                    exc = e;
                }
            }
            String reason = exc != null ? "of " + exc.toString() : "of a bad return: " + result2;
            String exc_msg = String.format(LARGE_METHOD_MSG, filename) + String.format(TRIED_CREATE_PYC_MSG, command, reason) + String.format(PLEASE_PROVIDE_MSG, filename) + CPYTHON_CMD_MSG;
            throw exc != null ? new RuntimeException(exc_msg, exc) : new RuntimeException(exc_msg);
        }
        throw new RuntimeException(String.format(LARGE_METHOD_MSG, filename) + String.format(PLEASE_PROVIDE_MSG, filename) + CPYTHON_CMD_MSG);
    }

    private static String serializePyBytecode(PyBytecode btcode) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream so = new ObjectOutputStream(bo);
        so.writeObject(btcode);
        so.flush();
        String code_str = Module.base64encodeToString(bo.toByteArray());
        so.close();
        bo.close();
        return code_str;
    }

    private static String base64encodeToString(byte[] data) {
        int quantum;
        int N = data.length;
        int tail = N % 3;
        StringBuilder chars = new StringBuilder((N / 3 + 1) * 4);
        int b = 0;
        while (b <= N - 3) {
            quantum = ((data[b++] & 0xFF) << 16) + ((data[b++] & 0xFF) << 8) + (data[b++] & 0xFF);
            chars.append(base64enc[quantum >> 18]);
            chars.append(base64enc[quantum >> 12 & 0x3F]);
            chars.append(base64enc[quantum >> 6 & 0x3F]);
            chars.append(base64enc[quantum & 0x3F]);
        }
        if (tail >= 1) {
            quantum = (data[b++] & 0xFF) << 8;
            if (tail == 2) {
                quantum += data[b++] & 0xFF;
            }
            chars.append(base64enc[quantum >> 10]);
            chars.append(base64enc[quantum >> 4 & 0x3F]);
            if (tail == 2) {
                chars.append(base64enc[quantum << 2 & 0x3F]);
            }
        }
        return chars.toString();
    }

    private static void insert_code_str_to_classfile(String name, String code_str, Module module) throws IOException {
        if (code_str.length() <= 65535) {
            module.classfile.addFinalStringLiteral("___0_" + name, code_str);
        } else {
            int splits = code_str.length() / 65535;
            if (code_str.length() % 65535 > 0) {
                ++splits;
            }
            int pos = 0;
            int i = 0;
            while (pos + 65535 <= code_str.length()) {
                module.classfile.addFinalStringLiteral("___" + splits + "_" + i + "_" + name, code_str.substring(pos, pos + 65535));
                pos += 65535;
                ++i;
            }
            if (i < splits) {
                module.classfile.addFinalStringLiteral("___" + splits + "_" + i + "_" + name, code_str.substring(pos));
            }
        }
    }

    public static void compile(mod node, OutputStream ostream, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags, long mtime) throws Exception {
        try {
            Module module = new Module(name, filename, linenumbers, mtime);
            Module._module_init(node, module, printResults, cflags);
            module.write(ostream);
        }
        catch (MethodTooLargeException re2) {
            PyBytecode btcode = Module.loadPyBytecode(filename, true);
            int thresh = 22000;
            while (true) {
                try {
                    ArrayList<PyBytecode> largest_m_codes = new ArrayList<PyBytecode>();
                    Stack<PyBytecode> buffer = new Stack<PyBytecode>();
                    buffer.push(btcode);
                    while (!buffer.isEmpty()) {
                        PyBytecode bcode = (PyBytecode)buffer.pop();
                        if (bcode.co_code.length > thresh) {
                            largest_m_codes.add(bcode);
                            continue;
                        }
                        for (PyObject item : bcode.co_consts) {
                            if (!(item instanceof PyBytecode)) continue;
                            PyBytecode mpbc = (PyBytecode)item;
                            buffer.push(mpbc);
                        }
                    }
                    Module module = new Module(name, filename, linenumbers, mtime);
                    module.oversized_methods = new Hashtable(largest_m_codes.size());
                    int ov_id = 0;
                    for (PyBytecode largest_m_code : largest_m_codes) {
                        String name_id = !PyCodeConstant.isJavaIdentifier(largest_m_code.co_name) ? "f$_" + ov_id++ : largest_m_code.co_name + "$_" + ov_id++;
                        if (largest_m_code.co_name.equals("<module>")) {
                            module.oversized_methods.put(largest_m_code.co_name + 0, name_id);
                        } else {
                            module.oversized_methods.put(largest_m_code.co_name + largest_m_code.co_firstlineno, name_id);
                        }
                        String code_str = Module.serializePyBytecode(largest_m_code);
                        Module.insert_code_str_to_classfile(name_id, code_str, module);
                    }
                    module.classfile.addInterface(CodegenUtils.p(ContainsPyBytecode.class));
                    Module._module_init(node, module, printResults, cflags);
                    module.write(ostream);
                }
                catch (MethodTooLargeException e) {
                    if ((thresh -= 1000) >= 10000) continue;
                    throw new RuntimeException("For unknown reason, too large method code couldn't be resolved\nby PyBytecode-approach:\n" + filename);
                }
                break;
            }
        }
    }

    public void emitNum(Num node, Code code2) throws Exception {
        if (node.getInternalN() instanceof PyInteger) {
            this.integerConstant(((PyInteger)node.getInternalN()).getValue()).get(code2);
        } else if (node.getInternalN() instanceof PyLong) {
            this.longConstant(((PyObject)node.getInternalN()).__str__().toString()).get(code2);
        } else if (node.getInternalN() instanceof PyFloat) {
            this.floatConstant(((PyFloat)node.getInternalN()).getValue()).get(code2);
        } else if (node.getInternalN() instanceof PyComplex) {
            this.complexConstant(((PyComplex)node.getInternalN()).imag).get(code2);
        }
    }

    public void emitStr(Str node, Code code2) throws Exception {
        PyString s = (PyString)node.getInternalS();
        if (s instanceof PyUnicode) {
            this.unicodeConstant(s.asString()).get(code2);
        } else {
            this.stringConstant(s.asString()).get(code2);
        }
    }

    public boolean emitPrimitiveArraySetters(List<? extends PythonTree> nodes, Code code2) throws Exception {
        int n = nodes.size();
        if (n < 100) {
            return false;
        }
        boolean primitive_literals = true;
        for (int i = 0; i < n; ++i) {
            PythonTree node = nodes.get(i);
            if (node instanceof Num || node instanceof Str) continue;
            primitive_literals = false;
        }
        if (!primitive_literals) {
            return false;
        }
        int num_setters = n / 4096 + 1;
        code2.iconst(n);
        code2.anewarray(CodegenUtils.p(PyObject.class));
        for (int i = 0; i < num_setters; ++i) {
            Code setter = this.classfile.addMethod("set$$" + this.setter_count, CodegenUtils.sig(Void.TYPE, PyObject[].class), 10);
            for (int j = 0; j < 4096 && i * 4096 + j < n; ++j) {
                setter.aload(0);
                setter.iconst(i * 4096 + j);
                PythonTree node = nodes.get(i * 4096 + j);
                if (node instanceof Num) {
                    this.emitNum((Num)node, setter);
                } else if (node instanceof Str) {
                    this.emitStr((Str)node, setter);
                }
                setter.aastore();
            }
            setter.return_();
            code2.dup();
            code2.invokestatic(this.classfile.name, "set$$" + this.setter_count, CodegenUtils.sig(Void.TYPE, PyObject[].class));
            ++this.setter_count;
        }
        return true;
    }
}

