/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.python27.core.Py;
import org.python27.core.PyException;
import org.python27.core.PyFrozenSet;
import org.python27.core.PyFrozenSetDerived;
import org.python27.core.PyIterator;
import org.python27.core.PyList;
import org.python27.core.PyObject;
import org.python27.core.PySet;
import org.python27.core.PyTuple;
import org.python27.core.PyType;
import org.python27.core.ThreadState;
import org.python27.core.Traverseproc;
import org.python27.core.Visitproc;
import org.python27.core.__builtin__;

public abstract class BaseSet
extends PyObject
implements Set,
Traverseproc {
    protected Set<PyObject> _set;

    protected BaseSet(PyType type, Set<PyObject> set) {
        super(type);
        this._set = set;
    }

    public Set<PyObject> getSet() {
        return this._set;
    }

    protected void _update(PyObject data) {
        BaseSet._update(this._set, data);
    }

    protected void _update(PyObject[] args) {
        BaseSet._update(this._set, args);
    }

    protected static Set<PyObject> _update(Set<PyObject> set, PyObject data) {
        if (data == null) {
            return set;
        }
        if (data instanceof BaseSet) {
            set.addAll(((BaseSet)data)._set);
        } else {
            for (PyObject item : data.asIterable()) {
                set.add(item);
            }
        }
        return set;
    }

    protected static Set<PyObject> _update(Set<PyObject> set, PyObject[] data) {
        if (data == null) {
            return set;
        }
        for (PyObject item : data) {
            set.add(item);
        }
        return set;
    }

    @Override
    public PyObject __or__(PyObject other) {
        return this.baseset___or__(other);
    }

    final PyObject baseset___or__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_union(other);
    }

    @Override
    public PyObject __and__(PyObject other) {
        return this.baseset___and__(other);
    }

    final PyObject baseset___and__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_intersection(other);
    }

    @Override
    public PyObject __sub__(PyObject other) {
        return this.baseset___sub__(other);
    }

    final PyObject baseset___sub__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_difference(other);
    }

    public PyObject difference(PyObject other) {
        return this.baseset_difference(other);
    }

    final PyObject baseset_difference(PyObject other) {
        return this.baseset_difference(new PyObject[]{other});
    }

    final PyObject baseset_difference(PyObject[] args) {
        if (args.length == 0) {
            return BaseSet.makeNewSet(this.getType(), this);
        }
        BaseSet o = BaseSet.makeNewSet(this.getType(), this);
        for (PyObject item : args) {
            BaseSet bs = args[0] instanceof BaseSet ? (BaseSet)item : new PySet(item);
            Set<PyObject> set = bs._set;
            for (PyObject p : set) {
                if (!this._set.contains(p)) continue;
                o._set.remove(p);
            }
        }
        return o;
    }

    @Override
    public PyObject __xor__(PyObject other) {
        return this.baseset___xor__(other);
    }

    final PyObject baseset___xor__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_symmetric_difference(other);
    }

    public PyObject symmetric_difference(PyObject other) {
        return this.baseset_symmetric_difference(other);
    }

    final PyObject baseset_symmetric_difference(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        BaseSet o = BaseSet.makeNewSet(this.getType());
        for (PyObject p : this._set) {
            if (bs._set.contains(p)) continue;
            o._set.add(p);
        }
        for (PyObject p : bs._set) {
            if (this._set.contains(p)) continue;
            o._set.add(p);
        }
        return o;
    }

    @Override
    public abstract int hashCode();

    @Override
    public int __len__() {
        return this.baseset___len__();
    }

    final int baseset___len__() {
        return this._set.size();
    }

    @Override
    public boolean __nonzero__() {
        return !this._set.isEmpty();
    }

    @Override
    public PyObject __iter__() {
        return this.baseset___iter__();
    }

    final PyObject baseset___iter__() {
        return new PyIterator(){
            private int size;
            private Iterator<PyObject> iterator;
            {
                this.size = BaseSet.this.size();
                this.iterator = BaseSet.this._set.iterator();
            }

            @Override
            public PyObject __iternext__() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }
        };
    }

    @Override
    public boolean __contains__(PyObject other) {
        return this.baseset___contains__(other);
    }

    final boolean baseset___contains__(PyObject other) {
        try {
            return this._set.contains(other);
        }
        catch (PyException pye) {
            PyFrozenSet frozen = this.asFrozen(pye, other);
            return this._set.contains(frozen);
        }
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.baseset___cmp__(other);
    }

    final int baseset___cmp__(PyObject other) {
        throw Py.TypeError("cannot compare sets using cmp()");
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.baseset___eq__(other);
    }

    final PyObject baseset___eq__(PyObject other) {
        Object jobj = other.__tojava__(Set.class);
        if (jobj instanceof Set) {
            Set jSet = (Set)jobj;
            if (jSet.size() != this.size()) {
                return Py.False;
            }
            for (Object otherItem : jSet) {
                if (this.contains(otherItem)) continue;
                return Py.False;
            }
            return Py.True;
        }
        return Py.False;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.baseset___ne__(other);
    }

    final PyObject baseset___ne__(PyObject other) {
        Object jobj = other.__tojava__(Set.class);
        if (jobj instanceof Set) {
            Set jSet = (Set)jobj;
            if (jSet.size() != this.size()) {
                return Py.True;
            }
            for (Object otherItem : jSet) {
                if (this.contains(otherItem)) continue;
                return Py.True;
            }
            return Py.False;
        }
        return Py.True;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.baseset___le__(other);
    }

    final PyObject baseset___le__(PyObject other) {
        return this.baseset_issubset(this.asBaseSet(other));
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.baseset___ge__(other);
    }

    final PyObject baseset___ge__(PyObject other) {
        return this.baseset_issuperset(this.asBaseSet(other));
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.baseset___lt__(other);
    }

    final PyObject baseset___lt__(PyObject other) {
        BaseSet bs = this.asBaseSet(other);
        return Py.newBoolean(this.size() < bs.size() && this.baseset_issubset(other).__nonzero__());
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.baseset___gt__(other);
    }

    final PyObject baseset___gt__(PyObject other) {
        BaseSet bs = this.asBaseSet(other);
        return Py.newBoolean(this.size() > bs.size() && this.baseset_issuperset(other).__nonzero__());
    }

    @Override
    public PyObject __reduce__() {
        return this.baseset___reduce__();
    }

    final PyObject baseset___reduce__() {
        PyTuple args = new PyTuple(new PyList(this));
        PyObject dict = this.__findattr__("__dict__");
        if (dict == null) {
            dict = Py.None;
        }
        return new PyTuple(this.getType(), args, dict);
    }

    final PyObject baseset_union(PyObject other) {
        BaseSet result2 = BaseSet.makeNewSet(this.getType(), this);
        result2._update(other);
        return result2;
    }

    final PyObject baseset_union(PyObject[] args) {
        BaseSet result2 = BaseSet.makeNewSet(this.getType(), this);
        for (PyObject item : args) {
            result2._update(item);
        }
        return result2;
    }

    final PyObject baseset_intersection(PyObject other) {
        PyObject big;
        PyObject little;
        if (!(other instanceof BaseSet)) {
            other = new PySet(other);
        }
        if (this.size() <= __builtin__.len(other)) {
            little = this;
            big = other;
        } else {
            little = other;
            big = this;
        }
        PyObject common = __builtin__.filter(big.__getattr__("__contains__"), little);
        return BaseSet.makeNewSet(this.getType(), common);
    }

    final PyObject baseset_intersection(PyObject[] args) {
        BaseSet result2 = BaseSet.makeNewSet(this.getType(), this);
        if (args.length == 0) {
            return result2;
        }
        for (PyObject other : args) {
            result2 = (BaseSet)result2.baseset_intersection(other);
        }
        return result2;
    }

    final PyObject baseset_copy() {
        BaseSet copy2 = BaseSet.makeNewSet(this.getType(), this);
        return copy2;
    }

    final PyObject baseset_issubset(PyObject other) {
        BaseSet bs;
        BaseSet baseSet = bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        if (this.size() > bs.size()) {
            return Py.False;
        }
        for (PyObject p : this._set) {
            if (bs._set.contains(p)) continue;
            return Py.False;
        }
        return Py.True;
    }

    final PyObject baseset_issuperset(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        return bs.baseset_issubset(this);
    }

    final PyObject baseset_isdisjoint(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        return Collections.disjoint(this._set, bs._set) ? Py.True : Py.False;
    }

    @Override
    public String toString() {
        return this.baseset_toString();
    }

    final String baseset_toString() {
        String name = this.getType().fastGetName();
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return name + "(...)";
        }
        StringBuilder buf = new StringBuilder(name).append("([");
        Iterator<PyObject> i = this._set.iterator();
        while (i.hasNext()) {
            buf.append(i.next().__repr__().toString());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("])");
        ts.exitRepr(this);
        return buf.toString();
    }

    protected final BaseSet asBaseSet(PyObject other) {
        if (other instanceof BaseSet) {
            return (BaseSet)other;
        }
        throw Py.TypeError("can only compare to a set");
    }

    protected final PyFrozenSet asFrozen(PyException pye, PyObject value) {
        if (!(value instanceof BaseSet) || !pye.match(Py.TypeError)) {
            throw pye;
        }
        PyFrozenSet tmp = new PyFrozenSet();
        tmp._set = ((BaseSet)value)._set;
        return tmp;
    }

    protected static BaseSet makeNewSet(PyType type) {
        return BaseSet.makeNewSet(type, null);
    }

    protected static BaseSet makeNewSet(PyType type, PyObject iterable) {
        BaseSet so = type == PySet.TYPE ? new PySet(iterable) : (type == PyFrozenSet.TYPE ? new PyFrozenSet(iterable) : (Py.isSubClass(type, PySet.TYPE) ? (BaseSet)type.__call__(iterable == null ? Py.EmptyTuple : iterable) : new PyFrozenSetDerived(type, iterable)));
        return so;
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    @Override
    public boolean add(Object o) {
        return this._set.add(Py.java2py(o));
    }

    @Override
    public boolean contains(Object o) {
        return this._set.contains(Py.java2py(o));
    }

    @Override
    public boolean remove(Object o) {
        return this._set.remove(Py.java2py(o));
    }

    @Override
    public boolean addAll(Collection c) {
        boolean added = false;
        for (Object object : c) {
            added |= this.add(object);
        }
        return added;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object object : c) {
            if (this._set.contains(Py.java2py(object))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean removed = false;
        for (Object object : c) {
            removed |= this._set.remove(Py.java2py(object));
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator<PyObject> real;
            {
                this.real = BaseSet.this._set.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.real.hasNext();
            }

            public Object next() {
                return Py.tojava(this.real.next(), Object.class);
            }

            @Override
            public void remove() {
                this.real.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        for (PyObject ob : this._set) {
            int retValue;
            if (ob == null || (retValue = visit.visit(ob, arg)) == 0) continue;
            return retValue;
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && this._set.contains(ob);
    }
}

