/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.python27.core.Options;
import org.python27.core.Py;

public class BytecodeNotification {
    private static List<Callback> callbacks = new CopyOnWriteArrayList<Callback>();

    public static void register(Callback n) {
        callbacks.add(n);
    }

    public static boolean unregister(Callback n) {
        return callbacks.remove(n);
    }

    public static void clear() {
        callbacks.clear();
    }

    public static void notify(String name, byte[] data, Class klass) {
        for (Callback c : callbacks) {
            try {
                c.notify(name, data, klass);
            }
            catch (Exception e) {
                Py.writeWarning("BytecodeNotification", "Exception from callback:" + e);
            }
        }
    }

    static {
        BytecodeNotification.register(new Callback(){

            @Override
            public void notify(String name, byte[] bytes, Class c) {
                if (Options.proxyDebugDirectory == null || !name.startsWith("org.python27.pycode.") && !name.startsWith("org.python27.proxies.")) {
                    return;
                }
                ByteArrayOutputStream ostream = new ByteArrayOutputStream(bytes.length);
                ostream.write(bytes, 0, bytes.length);
                Py.saveClassFile(name, ostream);
            }
        });
    }

    public static interface Callback {
        public void notify(String var1, byte[] var2, Class var3);
    }
}

