/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.python27.core.Py;
import org.python27.core.PyObject;
import org.python27.core.PySystemState;
import org.python27.core.Untraversable;

@Untraversable
public class JavaImporter
extends PyObject {
    public static final String JAVA_IMPORT_PATH_ENTRY = "__classpath__";
    private static Logger log = Logger.getLogger("org.python27.import");

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        if (args[0].toString().endsWith(JAVA_IMPORT_PATH_ENTRY)) {
            return this;
        }
        throw Py.ImportError("unable to handle");
    }

    public PyObject find_module(String name) {
        return this.find_module(name, Py.None);
    }

    public PyObject find_module(String name, PyObject path) {
        log.log(Level.FINE, "# trying {0} in package manager for path {1}", new Object[]{name, path});
        PyObject ret = PySystemState.packageManager.lookupName(name.intern());
        if (ret != null) {
            log.log(Level.CONFIG, "import {0} # as java package", name);
            return this;
        }
        return Py.None;
    }

    public PyObject load_module(String name) {
        return PySystemState.packageManager.lookupName(name.intern());
    }

    @Override
    public String toString() {
        return this.getType().toString();
    }
}

