/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.python27.core.MakeProxies;
import org.python27.core.Py;
import org.python27.core.PyCompoundCallable;
import org.python27.core.PyObject;
import org.python27.core.Untraversable;
import org.python27.util.Generic;

@Untraversable
public class PyBeanEventProperty
extends PyObject {
    private static Map<String, Class<?>> adapterClasses = Generic.map();
    private static Map<Object, Map<String, WeakReference<Object>>> adapters = new WeakHashMap<Object, Map<String, WeakReference<Object>>>();
    public Method addMethod;
    public String eventName;
    public Class<?> eventClass;
    public String __name__;
    private Field adapterField;
    private Class<?> adapterClass;

    public PyBeanEventProperty(String eventName, Class<?> eventClass, Method addMethod, Method eventMethod) {
        this.__name__ = eventMethod.getName().intern();
        this.addMethod = addMethod;
        this.eventName = eventName;
        this.eventClass = eventClass;
    }

    @Override
    public PyObject _doget(PyObject self) {
        Object field;
        if (self == null) {
            return this;
        }
        this.initAdapter();
        Object jself = Py.tojava(self, this.addMethod.getDeclaringClass());
        try {
            field = this.adapterField.get(this.getAdapter(jself));
        }
        catch (Exception exc) {
            throw Py.JavaError(exc);
        }
        if (field == null) {
            PyCompoundCallable func = new PyCompoundCallable();
            this.setFunction(jself, func);
            return func;
        }
        if (field instanceof PyCompoundCallable) {
            return (PyCompoundCallable)field;
        }
        PyCompoundCallable func = new PyCompoundCallable();
        this.setFunction(jself, func);
        func.append((PyObject)field);
        return func;
    }

    @Override
    public boolean _doset(PyObject self, PyObject value) {
        Object jself = Py.tojava(self, this.addMethod.getDeclaringClass());
        if (!(value instanceof PyCompoundCallable)) {
            PyCompoundCallable func = new PyCompoundCallable();
            this.setFunction(jself, func);
            func.append(value);
        } else {
            this.setFunction(jself, value);
        }
        return true;
    }

    @Override
    public String toString() {
        return "<beanEventProperty " + this.__name__ + " for event " + this.eventClass.toString() + " " + Py.idstr(this) + ">";
    }

    private Object getAdapter(Object o, String evc) {
        Map<String, WeakReference<Object>> ads = adapters.get(o);
        if (ads == null) {
            return null;
        }
        WeakReference<Object> adw = ads.get(evc);
        if (adw == null) {
            return null;
        }
        return adw.get();
    }

    private void putAdapter(Object o, String evc, Object ad) {
        Map<String, WeakReference<Object>> ads = adapters.get(o);
        if (ads == null) {
            ads = Generic.map();
            adapters.put(o, ads);
        }
        ads.put(evc, new WeakReference<Object>(ad));
    }

    private synchronized Object getAdapter(Object self) {
        String eventClassName = this.eventClass.getName();
        Object adapter = this.getAdapter(self, eventClassName);
        if (adapter != null) {
            return adapter;
        }
        try {
            adapter = this.adapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.addMethod.invoke(self, adapter);
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
        this.putAdapter(self, eventClassName, adapter);
        return adapter;
    }

    private void initAdapter() {
        if (this.adapterClass == null) {
            this.adapterClass = PyBeanEventProperty.getAdapterClass(this.eventClass);
            try {
                this.adapterField = this.adapterClass.getField(this.__name__);
            }
            catch (NoSuchFieldException exc) {
                throw Py.AttributeError("Internal bean event error: " + this.__name__);
            }
        }
    }

    private void setFunction(Object self, PyObject callable) {
        this.initAdapter();
        try {
            this.adapterField.set(this.getAdapter(self), callable);
        }
        catch (Exception exc) {
            throw Py.JavaError(exc);
        }
    }

    private static synchronized Class<?> getAdapterClass(Class<?> c) {
        String name = "org.python27.proxies." + c.getName() + "$Adapter";
        Class<?> pc = Py.findClass(name);
        if (pc == null && (pc = adapterClasses.get(name)) == null) {
            pc = MakeProxies.makeAdapter(c);
            adapterClasses.put(name, pc);
        }
        return pc;
    }
}

