/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.junit.runners.Parameterized;
import org.python27.core.BufferProtocol;
import org.python27.core.ByteBufferTestSupport;
import org.python27.core.PyBuffer;
import org.python27.core.PyBufferTest;
import org.python27.core.PyBufferTestSupport;
import org.python27.core.PyException;
import org.python27.core.buffer.BaseBuffer;
import org.python27.core.buffer.SimpleNIOBuffer;

public class PyBufferNIOTest
extends PyBufferTest {
    public PyBufferNIOTest(PyBufferTestSupport.TestSpec spec) {
        super(spec);
    }

    @Parameterized.Parameters
    public static Collection<PyBufferTestSupport.TestSpec[]> genTestSpecs() {
        PyBufferTestSupport s = new PyBufferTestSupport(sliceLengths, sliceSteps);
        PyBufferTestSupport.WritableExporterFactory rollYourOwnExporter = new PyBufferTestSupport.WritableExporterFactory(){

            @Override
            public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
                return new RollYourOwnExporter(m.getBuffer());
            }
        };
        s.add(rollYourOwnExporter, byteMaterial);
        s.add(rollYourOwnExporter, emptyMaterial);
        TestNIOExporterFactory readonlyHeapNIOExporter = new TestNIOExporterFactory(false, false);
        s.add(readonlyHeapNIOExporter, emptyMaterial);
        s.add(readonlyHeapNIOExporter, byteMaterial);
        s.add(readonlyHeapNIOExporter, longMaterial);
        TestNIOExporterFactory writableHeapNIOExporter = new TestNIOExporterFactory(true, false);
        s.add(writableHeapNIOExporter, emptyMaterial);
        s.add(writableHeapNIOExporter, byteMaterial);
        s.add(writableHeapNIOExporter, longMaterial);
        TestNIOExporterFactory readonlyDirectNIOExporter = new TestNIOExporterFactory(false, true);
        s.add(readonlyDirectNIOExporter, emptyMaterial);
        s.add(readonlyDirectNIOExporter, byteMaterial);
        s.add(readonlyDirectNIOExporter, longMaterial);
        TestNIOExporterFactory writableDirectNIOExporter = new TestNIOExporterFactory(true, true);
        s.add(writableDirectNIOExporter, emptyMaterial);
        s.add(writableDirectNIOExporter, byteMaterial);
        s.add(writableDirectNIOExporter, longMaterial);
        List<PyBufferTestSupport.TestSpec[]> ret = s.getTestData();
        return ret;
    }

    private static class RollYourOwnNIOBuffer
    extends BaseBuffer {
        static final int FEATURES = 0x10000001;
        final ByteBuffer storage;
        final PyBuffer root;

        public RollYourOwnNIOBuffer(int flags, BufferProtocol obj, ByteBuffer storage) {
            this(flags, null, obj, storage, storage.position(), storage.remaining(), 1);
        }

        public RollYourOwnNIOBuffer(int flags, PyBuffer root, BufferProtocol obj, ByteBuffer storage, int index0, int count2, int stride) throws IndexOutOfBoundsException, NullPointerException, PyException {
            super(0x10000001 | (index0 == 0 && stride == 1 ? 0 : 24), index0, new int[]{count2}, new int[]{stride});
            this.storage = storage.duplicate();
            if (count2 > 0) {
                int end = index0 + (count2 - 1) * stride;
                int END = storage.capacity() - 1;
                if (index0 < 0 || index0 > END || end < 0 || end > END) {
                    throw new IndexOutOfBoundsException();
                }
            }
            this.checkRequestFlags(flags);
            if (root == null) {
                this.root = this;
                this.obj = obj;
            } else {
                this.root = root.getBuffer(284);
                this.obj = root.getObj();
            }
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public PyBuffer getBufferSlice(int flags, int start, int count2, int stride) {
            int newStart = this.index0 + start * this.strides[0];
            int newStride = this.strides[0] * stride;
            return new RollYourOwnNIOBuffer(flags, this.root, null, this.storage, newStart, count2, newStride);
        }

        @Override
        public ByteBuffer getNIOByteBufferImpl() {
            return this.storage.duplicate();
        }

        @Override
        protected byte byteAtImpl(int byteIndex) {
            return this.storage.get(byteIndex);
        }

        @Override
        protected void storeAtImpl(byte value, int byteIndex) throws IndexOutOfBoundsException, PyException {
            this.storage.put(byteIndex, value);
        }
    }

    private static class RollYourOwnExporter
    extends PyBufferTest.TestableExporter {
        protected ByteBuffer storage;

        public RollYourOwnExporter(ByteBuffer storage) {
            this.storage = storage;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                pybuf = new RollYourOwnNIOBuffer(flags, this, this.storage);
                this.export = new WeakReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
    }

    static class TestNIOExporterFactory
    implements PyBufferTestSupport.ExporterFactory {
        final boolean writable;
        final boolean isDirect;

        TestNIOExporterFactory(boolean writable, boolean isDirect) {
            this.writable = writable;
            this.isDirect = isDirect;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public boolean isDirect() {
            return this.isDirect;
        }

        @Override
        public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
            ByteBuffer bb = m.getBuffer();
            if (this.isDirect) {
                ByteBuffer direct = ByteBuffer.allocateDirect(bb.capacity());
                direct.put(bb).flip();
                bb = direct;
            }
            if (!this.writable) {
                bb = bb.asReadOnlyBuffer();
            }
            return new TestNIOExporter(bb);
        }

        @Override
        public boolean isReadonly() {
            return !this.writable;
        }

        @Override
        public boolean hasArray() {
            return !this.isDirect && this.writable;
        }
    }

    private static class TestNIOExporter
    extends PyBufferTest.TestableExporter {
        protected ByteBuffer storage;

        public TestNIOExporter(ByteBuffer storage) {
            this.storage = storage;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                pybuf = new SimpleNIOBuffer(flags, this, this.storage){

                    @Override
                    protected void releaseAction() {
                        export = null;
                    }
                };
                this.export = new WeakReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
    }
}

