/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.python27.core.BufferProtocol;
import org.python27.core.ByteBufferTestSupport;
import org.python27.core.Py;
import org.python27.core.PyBuffer;
import org.python27.core.PyBufferTestSupport;
import org.python27.core.PyByteArray;
import org.python27.core.PyException;
import org.python27.core.PyString;
import org.python27.core.buffer.BaseBuffer;
import org.python27.core.buffer.SimpleBuffer;
import org.python27.core.buffer.SimpleStringBuffer;
import org.python27.core.buffer.SimpleWritableBuffer;
import org.python27.util.PythonInterpreter;

@RunWith(value=Parameterized.class)
public class PyBufferTest {
    protected int verbosity = 0;
    protected static final boolean PRINT_KEY = false;
    static final int LONG = 1000;
    protected static final int[] sliceLengths = new int[]{1, 2, 5, 0, 250};
    protected static final int[] sliceSteps = new int[]{1, 2, 3, 7};
    protected static PythonInterpreter interp = new PythonInterpreter();
    protected PyBufferTestSupport.TestSpec spec;
    protected ByteBufferTestSupport.ByteMaterial ref;
    protected BufferProtocol obj;
    protected PyBuffer view;
    protected static final ByteBufferTestSupport.ByteMaterial byteMaterial = new ByteBufferTestSupport.ByteMaterial(10, 16, 3);
    protected static final ByteBufferTestSupport.ByteMaterial abcMaterial = new ByteBufferTestSupport.ByteMaterial("abcdefgh");
    protected static final ByteBufferTestSupport.ByteMaterial stringMaterial = new ByteBufferTestSupport.ByteMaterial("Mon c\u00f4t\u00e9 f\u00e2cheux");
    protected static final ByteBufferTestSupport.ByteMaterial emptyMaterial = new ByteBufferTestSupport.ByteMaterial(new byte[0]);
    protected static final ByteBufferTestSupport.ByteMaterial longMaterial = new ByteBufferTestSupport.ByteMaterial(0, 1000, 5);
    private static final String[] validOrders = new String[]{"C-contiguous test fail", "F-contiguous test fail", "Any-contiguous test fail"};

    public PyBufferTest(PyBufferTestSupport.TestSpec spec) {
        this.spec = spec;
        this.ref = spec.ref;
        this.createObjAndView();
    }

    protected void createObjAndView() {
        PyBufferTestSupport.TestSpec.ObjectAndView pair = this.spec.makePair();
        this.obj = pair.obj;
        this.view = pair.view;
    }

    @Parameterized.Parameters
    public static Collection<PyBufferTestSupport.TestSpec[]> genTestSpecs() {
        PyBufferTestSupport s = new PyBufferTestSupport(sliceLengths, sliceSteps);
        SimpleExporterFactory simpleExporter = new SimpleExporterFactory();
        s.add(simpleExporter, byteMaterial);
        PyBufferTestSupport.WritableExporterFactory simpleWritableExporter = new PyBufferTestSupport.WritableExporterFactory(){

            @Override
            public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
                return new SimpleWritableExporter(m.getBytes());
            }
        };
        s.add(simpleWritableExporter, abcMaterial);
        s.add(simpleWritableExporter, emptyMaterial);
        PyBufferTestSupport.ReadonlyExporterFactory stringExporter = new PyBufferTestSupport.ReadonlyExporterFactory(){

            @Override
            public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
                return new StringExporter(m.string);
            }
        };
        s.add(stringExporter, stringMaterial);
        PyBufferTestSupport.WritableExporterFactory rollYourOwnExporter = new PyBufferTestSupport.WritableExporterFactory(){

            @Override
            public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
                return new RollYourOwnExporter(m.getBytes());
            }
        };
        s.add(rollYourOwnExporter, byteMaterial);
        s.add(rollYourOwnExporter, emptyMaterial);
        PyBufferTestSupport.WritableExporterFactory pyByteArrayExporter = new PyBufferTestSupport.WritableExporterFactory(){

            @Override
            public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
                return new PyByteArray(m.getBytes());
            }
        };
        s.add(pyByteArrayExporter, byteMaterial);
        s.add(pyByteArrayExporter, longMaterial);
        s.add(pyByteArrayExporter, emptyMaterial);
        PyBufferTestSupport.ReadonlyExporterFactory pyStringExporter = new PyBufferTestSupport.ReadonlyExporterFactory(){

            @Override
            public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
                return new PyString(m.string);
            }
        };
        s.add(pyStringExporter, abcMaterial);
        s.add(pyStringExporter, emptyMaterial);
        PyBufferTestSupport.WritableExporterFactory offsetPyByteArrayExporter = new PyBufferTestSupport.WritableExporterFactory(){

            @Override
            public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
                int OFFSET = 4;
                byte[] b = m.getBytes();
                byte[] data = new byte[4 + b.length];
                System.arraycopy(b, 0, data, 4, b.length);
                PyByteArray a = new PyByteArray(data);
                a.delRange(0, 4);
                assert (a.__alloc__() > b.length);
                return a;
            }
        };
        s.add(offsetPyByteArrayExporter, byteMaterial);
        s.add(offsetPyByteArrayExporter, longMaterial);
        List<PyBufferTestSupport.TestSpec[]> ret = s.getTestData();
        return ret;
    }

    protected void announce(String api) {
        if (this.verbosity > 0) {
            System.out.printf("%-30s %s\n", api + ":", this.spec.toString());
        }
    }

    @Test
    public void testIsReadonly() {
        this.announce("isReadonly");
        Assert.assertTrue((this.view.isReadonly() == this.spec.readonly ? 1 : 0) != 0);
    }

    @Test
    public void testGetNdim() {
        this.announce("getNdim");
        Assert.assertEquals((String)"unexpected ndim", (long)this.spec.shape.length, (long)this.view.getNdim());
    }

    @Test
    public void testGetShape() {
        this.announce("getShape");
        int[] shape = this.view.getShape();
        Assert.assertNotNull((String)"shape[] should always be provided", (Object)shape);
        ByteBufferTestSupport.assertIntsEqual("unexpected shape", this.spec.shape, shape);
    }

    @Test
    public void testGetLen() {
        this.announce("getLen");
        Assert.assertEquals((String)"unexpected length", (long)this.ref.length, (long)this.view.getLen());
    }

    @Test
    public void testGetObj() {
        this.announce("getObj");
        Assert.assertEquals((String)"unexpected exporting object", (Object)this.obj, (Object)this.view.getObj());
    }

    @Test
    public void testByteAt() {
        this.announce("byteAt");
        for (int i = 0; i < this.ref.length; ++i) {
            Assert.assertEquals((long)this.ref.bytes[i], (long)this.view.byteAt(i));
        }
    }

    @Test
    public void testByteAtNdim() {
        this.announce("byteAt (n-dim)");
        int[] index = new int[1];
        if (this.view.getShape().length != 1) {
            Assert.fail((String)"Test not implemented if dimensions != 1");
        }
        for (int i = 0; i < this.ref.length; ++i) {
            index[0] = i;
            Assert.assertEquals((long)this.ref.bytes[i], (long)this.view.byteAt(index));
        }
        try {
            this.view.byteAt(0, 0);
            Assert.fail((String)"Use of 2D index did not raise exception");
        }
        catch (PyException pye) {
            Assert.assertEquals((Object)Py.BufferError, (Object)pye.type);
        }
    }

    @Test
    public void testIntAt() {
        this.announce("intAt");
        for (int i = 0; i < this.ref.length; ++i) {
            Assert.assertEquals((long)this.ref.ints[i], (long)this.view.intAt(i));
        }
    }

    @Test
    public void testIntAtNdim() {
        this.announce("intAt (n-dim)");
        int[] index = new int[1];
        if (this.view.getShape().length != 1) {
            Assert.fail((String)"Test not implemented for dimensions != 1");
        }
        for (int i = 0; i < this.ref.length; ++i) {
            index[0] = i;
            Assert.assertEquals((long)this.ref.ints[i], (long)this.view.intAt(index));
        }
        try {
            this.view.intAt(0, 0);
            Assert.fail((String)"Use of 2D index did not raise exception");
        }
        catch (PyException pye) {
            Assert.assertEquals((Object)Py.BufferError, (Object)pye.type);
        }
    }

    @Test
    public void testStoreAt() {
        this.announce("storeAt");
        int n = this.ref.length;
        int[] exp = (int[])this.ref.ints.clone();
        if (!this.spec.readonly) {
            int i;
            for (i = 0; i < n; ++i) {
                byte v = (byte)(exp[i] ^ 3);
                this.view.storeAt(v, i);
            }
            for (i = 0; i < n; ++i) {
                Assert.assertEquals((long)(exp[i] ^ 3), (long)this.view.intAt(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                try {
                    this.view.storeAt((byte)3, i);
                    Assert.fail((String)("Write access not prevented: " + this.spec));
                    continue;
                }
                catch (PyException pye) {
                    Assert.assertEquals((Object)Py.TypeError, (Object)pye.type);
                }
            }
        }
    }

    @Test
    public void testStoreAtNdim() {
        this.announce("storeAt (n-dim)");
        int[] index = new int[1];
        int n = this.ref.length;
        int[] exp = (int[])this.ref.ints.clone();
        if (!this.spec.readonly) {
            int i;
            for (i = 0; i < n; ++i) {
                index[0] = i;
                byte v = (byte)(exp[i] ^ 3);
                this.view.storeAt(v, index);
            }
            for (i = 0; i < n; ++i) {
                index[0] = i;
                Assert.assertEquals((long)(exp[i] ^ 3), (long)this.view.intAt(index));
            }
            if (this.spec.shape.length == 1) {
                try {
                    this.view.storeAt((byte)1, 0, 0);
                    Assert.fail((String)"Use of 2D index did not raise exception");
                }
                catch (PyException pye) {
                    Assert.assertEquals((Object)Py.BufferError, (Object)pye.type);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                index[0] = i;
                try {
                    this.view.storeAt((byte)3, index);
                    Assert.fail((String)("Write access not prevented: " + this.spec));
                    continue;
                }
                catch (PyException pye) {
                    Assert.assertEquals((Object)Py.TypeError, (Object)pye.type);
                }
            }
        }
    }

    @Test
    public void testCopyTo() {
        int OFFSET = 5;
        this.announce("copyTo");
        int n = this.ref.length;
        byte[] actual = new byte[n];
        this.view.copyTo(actual, 0);
        ByteBufferTestSupport.assertBytesEqual("copyTo() incorrect", this.ref.bytes, actual, 0);
        actual = new byte[n + 10];
        this.view.copyTo(actual, 5);
        ByteBufferTestSupport.assertBytesEqual("copyTo(offset) incorrect", this.ref.bytes, actual, 5);
        Assert.assertEquals((String)"data before destination", (long)0L, (long)actual[4]);
        Assert.assertEquals((String)"data after destination", (long)0L, (long)actual[5 + n]);
    }

    @Test
    public void testSliceCopyTo() {
        this.announce("copyTo (from slice)");
        int OFFSET = 3;
        int n = this.ref.length;
        byte[] before = new byte[n + 6];
        int BLANK = 7;
        Arrays.fill(before, (byte)7);
        for (int destPos = 0; destPos <= 3; destPos += 3) {
            for (int srcIndex = 0; srcIndex <= 3; srcIndex += 3) {
                int length = 0;
                while (srcIndex + length <= n) {
                    this.doTestSliceCopyTo(srcIndex, before, destPos, length, n);
                    length = 2 * length + 1;
                }
                int trim = 0;
                while (srcIndex + trim <= n) {
                    int length2 = n - srcIndex - trim;
                    this.doTestSliceCopyTo(srcIndex, before, destPos, length2, n);
                    trim = 2 * trim + 1;
                }
            }
        }
    }

    private void doTestSliceCopyTo(int srcIndex, byte[] before, int destPos, int length, int n) {
        if (this.verbosity > 1) {
            System.out.printf("  copy src[%d:%d] (%d) to dst[%d:%d] (%d)\n", srcIndex, srcIndex + length, n, destPos, destPos + length, before.length);
        }
        byte[] dest = (byte[])before.clone();
        this.view.copyTo(srcIndex, dest, destPos, length);
        byte[] viewBytes = PyBufferTestSupport.bytesFromByteAt(this.view);
        ByteBufferTestSupport.checkReadCorrect(this.ref.bytes, viewBytes, dest, destPos, length, 1, srcIndex, 1);
    }

    @Test
    public void testCopyFrom() {
        this.announce("copyFrom");
        int OFFSET = 3;
        int L = this.ref.length;
        byte[] src = new ByteBufferTestSupport.ByteMaterial((int)48, (int)(this.ref.length + 3), (int)1).bytes;
        PyBufferTestSupport.TestSpec underlying = this.spec.getOriginal();
        int start = this.spec.getStart();
        int stride = this.spec.getStride();
        for (int srcPos = 0; srcPos <= 3; srcPos += 3) {
            for (int destIndex = 0; destIndex <= 3; destIndex += 3) {
                int length = 0;
                while (destIndex + length <= L) {
                    this.doTestCopyFrom(src, srcPos, underlying, start, length, stride, destIndex);
                    length = 2 * length + 1;
                }
                int trim = 0;
                while (destIndex + trim <= L) {
                    int length2 = this.ref.length - destIndex - trim;
                    this.doTestCopyFrom(src, srcPos, underlying, start, length2, stride, destIndex);
                    trim = 2 * trim + 1;
                }
            }
        }
    }

    private void doTestCopyFrom(byte[] src, int srcPos, PyBufferTestSupport.TestSpec underlying, int start, int length, int stride, int destIndex) {
        if (this.verbosity > 1) {
            System.out.printf("  copy src[%d:%d] (%d) to dst[%d:%d]\n", srcPos, srcPos + length, this.ref.length, destIndex, destIndex + length);
        }
        this.createObjAndView();
        PyBuffer underlyingView = this.obj.getBuffer(underlying.flags & 0xFFFFFFFE);
        byte[] before = PyBufferTestSupport.bytesFromByteAt(underlyingView);
        if (!this.spec.readonly) {
            this.view.copyFrom(src, srcPos, destIndex, length);
            byte[] after = PyBufferTestSupport.bytesFromByteAt(underlyingView);
            int underlyingDestIndex = start + destIndex * stride;
            ByteBufferTestSupport.checkWriteCorrect(before, after, src, srcPos, length, 1, underlyingDestIndex, stride);
        } else {
            try {
                this.view.copyFrom(src, srcPos, destIndex, length);
                Assert.fail((String)("Write access not prevented: " + this.spec));
            }
            catch (PyException pye) {
                Assert.assertEquals((Object)Py.TypeError, (Object)pye.type);
            }
        }
    }

    @Test
    public void testCopyFromPyBuffer() {
        PyBufferTestSupport.ExporterFactory[] factories;
        this.announce("copyFrom (PyBuffer)");
        int n = this.spec.ref.length;
        int p = this.spec.getStride();
        int[] srcStrides = n < 2 ? new int[]{1} : (p > 2 || p < -2 ? new int[]{1, p - 1, p, p + 1, -p + 1, -p, -p - 1} : (p == 2 || p == -2 ? new int[]{1, 2, 3, -1, -2, -3} : new int[]{1, 2, -1, -2}));
        int maxStride = 0;
        for (int stride : srcStrides) {
            if (stride > maxStride) {
                maxStride = stride;
                continue;
            }
            if (-stride <= maxStride) continue;
            maxStride = -stride;
        }
        int maxOffset = n + 1;
        int[] srcOffsets = new int[]{0, (maxOffset + 1) / 3, maxOffset};
        int srcMaterialSize = n * maxStride + maxOffset;
        ByteBufferTestSupport.ByteMaterial srcMaterial = new ByteBufferTestSupport.ByteMaterial(48, srcMaterialSize, 1);
        for (PyBufferTestSupport.ExporterFactory factory : factories = new PyBufferTestSupport.ExporterFactory[]{this.spec.factory, new SimpleExporterFactory()}) {
            PyBufferTestSupport.TestSpec original = new PyBufferTestSupport.TestSpec(factory, srcMaterial);
            for (int stride : srcStrides) {
                for (int offset : srcOffsets) {
                    int start = stride > 0 ? offset : srcMaterialSize - offset - 1;
                    this.doTestCopyFrom(original, start, n, stride);
                }
            }
        }
    }

    private void doTestCopyFrom(PyBufferTestSupport.TestSpec original, int start, int n, int stride) {
        PyBufferTestSupport.SlicedTestSpec srcSpec = new PyBufferTestSupport.SlicedTestSpec(original, 1, start, n, stride);
        PyBufferTestSupport.TestSpec.ObjectAndView pair = ((PyBufferTestSupport.TestSpec)srcSpec).makePair();
        PyBuffer src = pair.view;
        byte[] srcBytes = srcSpec.ref.bytes;
        int s = this.spec.getStart();
        int p = this.spec.getStride();
        String srcName = pair.obj.getClass().getSimpleName();
        if (this.verbosity > 1) {
            int end = start + (n - 1) * stride + (stride > 0 ? 1 : -1);
            int e = s + (n - 1) * p + (p > 0 ? 1 : -1);
            System.out.printf("  copy from src[%d:%d:%d] %s(%d) to obj[%d:%d:%d]\n", start, end, stride, srcName, n, s, e, p);
        }
        this.createObjAndView();
        PyBufferTestSupport.TestSpec underlying = this.spec.getOriginal();
        PyBuffer underlyingView = this.obj.getBuffer(underlying.flags & 0xFFFFFFFE);
        byte[] before = PyBufferTestSupport.bytesFromByteAt(underlyingView);
        if (!this.spec.readonly) {
            this.view.copyFrom(src);
            byte[] after = PyBufferTestSupport.bytesFromByteAt(underlyingView);
            ByteBufferTestSupport.checkWriteCorrect(before, after, srcBytes, 0, n, 1, s, p);
        } else {
            try {
                this.view.copyFrom(src);
                Assert.fail((String)("Write access not prevented: " + this.spec));
            }
            catch (PyException pye) {
                Assert.assertEquals((Object)Py.TypeError, (Object)pye.type);
            }
        }
    }

    @Test
    public void testCopyFromSelf() {
        this.announce("copyFrom (self)");
        int n = this.ref.length;
        PyBufferTestSupport.TestSpec original = this.spec.getOriginal();
        if (this.spec.readonly || this.spec == original || n < 1) {
            return;
        }
        int p = this.spec.getStride();
        int L = original.ref.length;
        int[] srcStrides = n < 2 ? new int[]{1} : (p > 2 || p < -2 ? new int[]{1, p - 1, p, p + 1, -p + 1, -p, -p - 1} : (p == 2 || p == -2 ? new int[]{1, 2, 3, -1, -2, -3} : new int[]{1, 2, -1, -2}));
        for (int srcStride : srcStrides) {
            int srcOffset;
            int incOffset;
            int absStride;
            if (srcStride > 0) {
                absStride = srcStride;
                int maxOffset = L - 1 - absStride * (n - 1);
                if (maxOffset < 0) continue;
                incOffset = 1 + maxOffset / 4;
                for (srcOffset = 0; srcOffset <= maxOffset; srcOffset += incOffset) {
                    this.doTestCopyFromSelf(srcOffset, srcStride, n);
                }
                continue;
            }
            absStride = -srcStride;
            int minOffset = absStride * (n - 1) + 1;
            if (minOffset >= L) continue;
            incOffset = 1 + (L - 1 - minOffset) / 4;
            for (srcOffset = L - 1; srcOffset > minOffset; srcOffset -= incOffset) {
                this.doTestCopyFromSelf(srcOffset, srcStride, n);
            }
        }
    }

    private void doTestCopyFromSelf(int srcStart, int srcStride, int n) {
        this.createObjAndView();
        int dstStart = this.spec.getStart();
        int dstStride = this.spec.getStride();
        String srcName = this.obj.getClass().getSimpleName();
        if (this.verbosity > 1) {
            int srcEnd = srcStart + (n - 1) * srcStride + (srcStride > 0 ? 1 : -1);
            int dstEnd = dstStart + (n - 1) * dstStride + (dstStride > 0 ? 1 : -1);
            System.out.printf("  copy from obj[%d:%d:%d] %s(%d) to obj[%d:%d:%d]\n", srcStart, srcEnd, srcStride, srcName, n, dstStart, dstEnd, dstStride);
        }
        assert (!this.spec.readonly);
        try (PyBuffer underlying = this.obj.getBuffer(284);){
            byte[] before = PyBufferTestSupport.bytesFromByteAt(underlying);
            PyBuffer src = underlying.getBufferSlice(284, srcStart, n, srcStride);
            byte[] srcBytes = PyBufferTestSupport.bytesFromByteAt(src);
            this.view.copyFrom(src);
            byte[] after = PyBufferTestSupport.bytesFromByteAt(underlying);
            ByteBufferTestSupport.checkWriteCorrect(before, after, srcBytes, 0, n, 1, dstStart, dstStride);
        }
    }

    public void testGetBufferForRead() {
        this.announce("getBuffer(READ): ");
        for (int flags : this.spec.validFlags) {
            for (int tassles : this.spec.validTassles) {
                PyBuffer view2 = this.view.getBuffer(flags | tassles);
                Assert.assertNotNull((Object)view2);
            }
        }
    }

    public void testGetBufferForWrite() {
        this.announce("getBuffer(WRITE): ");
        if (!this.spec.readonly) {
            for (int flags : this.spec.validFlags) {
                for (int tassles : this.spec.validTassles) {
                    PyBuffer view2 = this.view.getBuffer(flags | tassles | 1);
                    Assert.assertNotNull((Object)view2);
                }
            }
        } else {
            for (int flags : this.spec.validFlags) {
                try {
                    this.view.getBuffer(flags | 1);
                    Assert.fail((String)("Write access not prevented: " + this.spec));
                }
                catch (PyException pye) {
                    Assert.assertEquals((Object)Py.BufferError, (Object)pye.type);
                }
            }
        }
    }

    @Test
    public void testReleaseTryWithResources() {
        this.announce("release (via try)");
        int flags = 28;
        try {
            PyBuffer c = this.obj.getBuffer(flags);
            Throwable throwable = null;
            try {
                try {
                    try (PyBuffer b = this.obj.getBuffer(284);
                         PyBuffer d = c.getBuffer(flags);){
                        this.maybeCheckExporting(this.obj);
                    }
                    this.maybeCheckExporting(this.obj);
                    throw new Throwable("test");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        c.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable) {
            this.maybeCheckExporting(this.obj);
            this.view.release();
            this.maybeCheckNotExporting(this.obj);
            return;
        }
    }

    @Test
    public void testRelease() {
        this.announce("release");
        int flags = 28;
        PyBuffer a = this.view;
        PyBuffer b = this.obj.getBuffer(284);
        PyBuffer c = this.obj.getBuffer(flags);
        this.maybeCheckExporting(this.obj);
        b.release();
        a.release();
        this.maybeCheckExporting(this.obj);
        PyBuffer d = c.getBuffer(flags);
        c.release();
        this.maybeCheckExporting(this.obj);
        d.release();
        try {
            this.view.release();
            Assert.fail((String)"excess release not detected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetAfterRelease() {
        this.announce("getBuffer (after release)");
        this.view.release();
        this.maybeCheckNotExporting(this.obj);
        this.maybeCheckNotExporting(this.view);
        try {
            this.view.getBuffer(284);
            Assert.fail((String)"PyBuffer.getBuffer after final release not detected");
        }
        catch (Exception e) {
            this.maybeCheckNotExporting(this.obj);
        }
        try {
            this.view.getBufferSlice(284, 0, 0);
            Assert.fail((String)"PyBuffer.getBufferSlice after final release not detected");
        }
        catch (Exception e) {
            this.maybeCheckNotExporting(this.obj);
        }
        PyBuffer b = this.obj.getBuffer(284);
        this.maybeCheckExporting(this.obj);
        b.release();
        this.maybeCheckNotExporting(this.obj);
    }

    private void maybeCheckExporting(BufferProtocol subject) {
        if (subject instanceof TestableExporter) {
            Assert.assertTrue((String)"exports not being counted", (boolean)((TestableExporter)subject).isExporting());
        } else if (subject instanceof PyBuffer) {
            Assert.assertFalse((String)"exports not being counted (PyBuffer)", (boolean)((PyBuffer)subject).isReleased());
        } else if (subject instanceof PyByteArray) {
            try {
                ((PyByteArray)subject).bytearray_append(Py.One);
                Assert.fail((String)"bytearray_append with exports should fail");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void maybeCheckNotExporting(BufferProtocol subject) {
        if (subject instanceof TestableExporter) {
            Assert.assertFalse((String)"exports counted incorrectly", (boolean)((TestableExporter)subject).isExporting());
        } else if (subject instanceof PyBuffer) {
            Assert.assertTrue((String)"exports counted incorrectly (PyBuffer)", (boolean)((PyBuffer)subject).isReleased());
        } else if (subject instanceof PyByteArray) {
            try {
                PyByteArray sub = (PyByteArray)subject;
                sub.bytearray_append(Py.Zero);
                sub.del(sub.__len__() - 1);
            }
            catch (Exception e) {
                Assert.fail((String)"bytearray unexpectedly locked");
            }
        }
    }

    @Test
    public void testGetBufferSliceWithStride() {
        this.announce("getBuffer (slice & stride)");
        int N = this.ref.length;
        int M = (N + 4) / 4;
        for (int start = 0; start <= N; start += M) {
            for (int length : sliceLengths) {
                if (length == 0) {
                    this.doTestGetBufferSliceWithStride(start, 0, 1);
                    this.doTestGetBufferSliceWithStride(start, 0, 2);
                    continue;
                }
                if (length == 1 && start < N) {
                    this.doTestGetBufferSliceWithStride(start, 1, 1);
                    this.doTestGetBufferSliceWithStride(start, 1, 2);
                    continue;
                }
                if (start >= N) continue;
                for (int step : sliceSteps) {
                    if (start + (length - 1) * step >= N) continue;
                    this.doTestGetBufferSliceWithStride(start, length, step);
                }
                for (int step : sliceSteps) {
                    if (start - (length - 1) * step < 0) continue;
                    this.doTestGetBufferSliceWithStride(start, length, -step);
                }
            }
        }
    }

    private void doTestGetBufferSliceWithStride(int first, int count2, int step) {
        PyBufferTestSupport.SlicedTestSpec slicedSpec = new PyBufferTestSupport.SlicedTestSpec(this.spec, this.spec.getItemsize(), first, count2, step);
        if (this.verbosity > 1) {
            System.out.printf("  slice first=%4d, count=%4d, step=%4d -> underlying start=%4d, stride=%4d\n", first, count2, step, ((PyBufferTestSupport.TestSpec)slicedSpec).getStart(), slicedSpec.getStride());
        }
        PyBuffer slicedView = this.view.getBufferSlice(this.spec.flags, first, count2, step);
        byte[] slice2 = PyBufferTestSupport.bytesFromByteAt(slicedView);
        ByteBufferTestSupport.assertBytesEqual("slice incorrect", slicedSpec.ref.bytes, slice2);
    }

    @Test
    public void testGetNIOByteBuffer() {
        this.announce("getNIOByteBuffer");
        int stride = this.spec.getStride();
        ByteBuffer bb = this.view.getNIOByteBuffer();
        ByteBufferTestSupport.assertBytesEqual("buffer does not match reference", this.ref.bytes, bb, stride);
        if (this.spec.readonly) {
            Assert.assertTrue((String)"ByteBuffer should be read-only", (boolean)bb.isReadOnly());
        } else {
            Assert.assertFalse((String)"ByteBuffer should not be read-only", (boolean)bb.isReadOnly());
        }
    }

    @Test
    public void testHasArray() {
        this.announce("hasArray");
        if (this.spec.hasArray) {
            Assert.assertTrue((String)"a backing array was expected", (boolean)this.view.hasArray());
        } else {
            Assert.assertFalse((String)"no backing array was expected", (boolean)this.view.hasArray());
        }
    }

    @Test
    public void testGetBuf() {
        this.announce("getBuf");
        if (this.spec.hasArray) {
            int stride = this.spec.getStride();
            PyBuffer.Pointer bp = this.view.getBuf();
            PyBufferTest.assertBytesEqual("buffer does not match reference", this.ref.bytes, bp, stride);
        }
    }

    @Test
    public void testGetPointer() {
        this.announce("getPointer");
        if (this.spec.hasArray) {
            int itemsize = this.spec.getItemsize();
            byte[] exp = new byte[itemsize];
            byte[] bytes = this.ref.bytes;
            for (int i = 0; i <= this.ref.length - itemsize; ++i) {
                int p = i * itemsize;
                for (int j = 0; j < itemsize; ++j) {
                    exp[j] = bytes[p + j];
                }
                PyBuffer.Pointer bp = this.view.getPointer(i);
                PyBufferTest.assertBytesEqual("getPointer value", exp, bp);
            }
        }
    }

    @Test
    public void testGetPointerNdim() {
        int[] index = new int[1];
        this.announce("getPointer(array)");
        if (this.spec.hasArray) {
            int n = this.ref.length;
            int itemsize = this.view.getItemsize();
            byte[] exp = new byte[itemsize];
            byte[] bytes = this.ref.bytes;
            int i = 0;
            while (i < n) {
                int p = i * itemsize;
                for (int j = 0; j < itemsize; ++j) {
                    exp[j] = bytes[p + j];
                }
                index[0] = i++;
                PyBuffer.Pointer bp = this.view.getPointer(index);
                PyBufferTest.assertBytesEqual("getPointer value", exp, bp);
            }
            try {
                this.view.getPointer(0, 0);
                Assert.fail((String)"Use of 2D index did not raise exception");
            }
            catch (PyException pye) {
                Assert.assertEquals((Object)Py.BufferError, (Object)pye.type);
            }
        }
    }

    @Test
    public void testGetStrides() {
        this.announce("getStrides");
        for (int flags : this.spec.validFlags) {
            PyBuffer view = this.view.getBuffer(flags);
            int[] strides = view.getStrides();
            Assert.assertNotNull((String)"strides[] should always be provided", (Object)strides);
            if (this.ref.bytes.length <= 1) continue;
            ByteBufferTestSupport.assertIntsEqual("unexpected strides", this.spec.strides, strides);
        }
    }

    @Test
    public void testGetSuboffsets() {
        this.announce("getSuboffsets");
        Assert.assertNull((Object)this.view.getSuboffsets());
    }

    @Test
    public void testIsContiguous() {
        this.announce("isContiguous");
        int ndim = this.spec.shape[0];
        int stride = this.spec.getStride();
        int itemsize = this.spec.getItemsize();
        boolean contig = ndim < 2 || stride == itemsize;
        for (String orderMsg : validOrders) {
            char order = orderMsg.charAt(0);
            Assert.assertEquals((String)orderMsg, (Object)this.view.isContiguous(order), (Object)contig);
        }
    }

    @Test
    public void testGetFormat() {
        this.announce("getFormat");
        PyBufferTestSupport.TestSpec spec = this.spec;
        for (int flags : spec.validFlags) {
            PyBuffer view = this.view.getBuffer(flags);
            Assert.assertNotNull((String)"format should always be provided", (Object)view.getFormat());
            Assert.assertEquals((Object)"B", (Object)view.getFormat());
            view = this.view.getBuffer(flags | 4);
            Assert.assertEquals((Object)"B", (Object)view.getFormat());
        }
    }

    @Test
    public void testGetItemsize() {
        this.announce("getItemsize");
        Assert.assertEquals((long)1L, (long)this.view.getItemsize());
    }

    @Test
    public void testToString() {
        this.announce("toString");
        String r = this.view.toString();
        Assert.assertEquals((String)"buffer does not match reference", (Object)this.ref.string, (Object)r);
    }

    private static void assertBytesEqual(String message2, byte[] expected, PyBuffer.Pointer bp) {
        PyBufferTest.assertBytesEqual(message2, expected, bp, 1);
    }

    private static void assertBytesEqual(String message2, byte[] expected, PyBuffer.Pointer bp, int stride) {
        ByteBufferTestSupport.assertBytesEqual(message2, expected, 0, expected.length, bp.storage, bp.offset, stride);
    }

    private static class RollYourOwnArrayBuffer
    extends BaseBuffer {
        static final int FEATURES = 0x10000001;
        final byte[] storage;
        final PyBuffer root;

        public RollYourOwnArrayBuffer(int flags, BufferProtocol obj, byte[] storage) {
            this(flags, null, obj, storage, 0, storage.length, 1);
        }

        public RollYourOwnArrayBuffer(int flags, PyBuffer root, BufferProtocol obj, byte[] storage, int index0, int count2, int stride) throws IndexOutOfBoundsException, NullPointerException, PyException {
            super(0x10000001 | (index0 == 0 && stride == 1 ? 0 : 24), index0, new int[]{count2}, new int[]{stride});
            this.storage = storage;
            if (count2 > 0) {
                int end = index0 + (count2 - 1) * stride;
                int END = storage.length - 1;
                if (index0 < 0 || index0 > END || end < 0 || end > END) {
                    throw new IndexOutOfBoundsException();
                }
            }
            this.checkRequestFlags(flags);
            if (root == null) {
                this.root = this;
                this.obj = obj;
            } else {
                this.root = root.getBuffer(284);
                this.obj = root.getObj();
            }
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public PyBuffer getBufferSlice(int flags, int start, int length, int stride) {
            int newStart = this.index0 + start * this.strides[0];
            int newStride = this.strides[0] * stride;
            return new RollYourOwnArrayBuffer(flags, this.root, null, this.storage, newStart, length, newStride);
        }

        @Override
        public ByteBuffer getNIOByteBufferImpl() {
            return ByteBuffer.wrap(this.storage);
        }

        @Override
        protected byte byteAtImpl(int byteIndex) {
            return this.storage[byteIndex];
        }

        @Override
        protected void storeAtImpl(byte value, int byteIndex) throws IndexOutOfBoundsException, PyException {
            this.storage[byteIndex] = value;
        }
    }

    private static class RollYourOwnExporter
    extends TestableExporter {
        protected byte[] storage;

        public RollYourOwnExporter(byte[] storage) {
            this.storage = storage;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                pybuf = new RollYourOwnArrayBuffer(flags, this, this.storage);
                this.export = new WeakReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
    }

    private static class SimpleWritableExporter
    extends TestableExporter {
        protected byte[] storage;

        public SimpleWritableExporter(byte[] storage) {
            this.storage = storage;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                pybuf = new SimpleWritableBuffer(flags, this, this.storage){

                    @Override
                    protected void releaseAction() {
                        export = null;
                    }
                };
                this.export = new WeakReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
    }

    static class StringExporter
    extends TestableExporter {
        String storage;

        public StringExporter(String s) {
            this.storage = s;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                pybuf = new SimpleStringBuffer(flags, (BufferProtocol)this, this.storage);
                this.export = new SoftReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
    }

    static abstract class TestableExporter
    implements BufferProtocol {
        protected Reference<BaseBuffer> export;

        TestableExporter() {
        }

        protected BaseBuffer getExistingBuffer(int flags) {
            BaseBuffer pybuf = null;
            if (this.export != null && (pybuf = this.export.get()) != null) {
                pybuf = pybuf.getBufferAgain(flags);
            }
            return pybuf;
        }

        public boolean isExporting() {
            if (this.export != null) {
                PyBuffer pybuf = this.export.get();
                if (pybuf != null) {
                    return !pybuf.isReleased();
                }
                this.export = null;
            }
            return false;
        }
    }

    private static class SimpleExporterFactory
    extends PyBufferTestSupport.ReadonlyExporterFactory {
        private SimpleExporterFactory() {
        }

        @Override
        public BufferProtocol make(ByteBufferTestSupport.ByteMaterial m) {
            return new SimpleExporter(m.getBytes());
        }
    }

    static class SimpleExporter
    implements BufferProtocol {
        protected byte[] storage;

        public SimpleExporter(byte[] storage) {
            this.storage = storage;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            return new SimpleBuffer(flags, this, this.storage);
        }
    }
}

