/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.python27.core.Py;
import org.python27.core.PyNullImporter$PyExposer;
import org.python27.core.PyObject;
import org.python27.core.PyType;
import org.python27.core.Untraversable;
import org.python27.core.imp;
import org.python27.expose.ExposedType;

@Untraversable
@ExposedType(name="NullImporter", isBaseType=false)
public class PyNullImporter
extends PyObject {
    public static final PyType TYPE;

    public PyNullImporter(PyObject pathObj) {
        String pathStr = imp.fileSystemDecode(pathObj);
        if (pathStr.equals("")) {
            throw Py.ImportError("empty pathname");
        }
        if (PyNullImporter.isDir(pathStr)) {
            throw Py.ImportError("existing directory: " + pathStr);
        }
    }

    public PyObject find_module(String fullname) {
        return Py.None;
    }

    public PyObject find_module(String fullname, String path) {
        return Py.None;
    }

    final PyObject NullImporter_find_module(String fullname, String path) {
        return Py.None;
    }

    private static boolean isDir(String pathStr) {
        if (pathStr.equals("")) {
            return false;
        }
        try {
            Path path = FileSystems.getDefault().getPath(pathStr, new String[0]);
            if (!path.isAbsolute()) {
                path = FileSystems.getDefault().getPath(Py.getSystemState().getCurrentWorkingDir(), pathStr);
            }
            return path.toFile().isDirectory();
        }
        catch (InvalidPathException ex) {
            return false;
        }
    }

    static {
        PyType.addBuilder(PyNullImporter.class, new PyNullImporter$PyExposer());
        TYPE = PyType.fromClass(PyNullImporter.class);
        TYPE.setName("imp.NullImporter");
    }
}

