/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.python27.antlr.ast.cmpopType;
import org.python27.core.AbstractDict;
import org.python27.core.ArgParser;
import org.python27.core.JyAttribute;
import org.python27.core.MakeProxies;
import org.python27.core.Options;
import org.python27.core.Py;
import org.python27.core.PyBuiltinCallable;
import org.python27.core.PyBuiltinMethod;
import org.python27.core.PyClass;
import org.python27.core.PyDataDescr;
import org.python27.core.PyDictProxy;
import org.python27.core.PyDictionary;
import org.python27.core.PyException;
import org.python27.core.PyFrame;
import org.python27.core.PyFunction;
import org.python27.core.PyJavaType;
import org.python27.core.PyList;
import org.python27.core.PyLong;
import org.python27.core.PyMethodDescr;
import org.python27.core.PyNewWrapper;
import org.python27.core.PyNone;
import org.python27.core.PyObject;
import org.python27.core.PyProxy;
import org.python27.core.PySlot;
import org.python27.core.PyStaticMethod;
import org.python27.core.PyString;
import org.python27.core.PyStringMap;
import org.python27.core.PyTuple;
import org.python27.core.PyType$PyExposer;
import org.python27.core.PyTypeDerived;
import org.python27.core.PyUnicode;
import org.python27.core.Traverseproc;
import org.python27.core.Visitproc;
import org.python27.core.imp;
import org.python27.expose.ExposeAsSuperclass;
import org.python27.expose.ExposedNew;
import org.python27.expose.ExposedType;
import org.python27.expose.TypeBuilder;
import org.python27.modules._weakref.WeakrefModule;
import org.python27.util.Generic;

@ExposedType(name="type", doc="type(object) -> the object's type\ntype(name, bases, dict) -> a new type")
public class PyType
extends PyObject
implements Serializable,
Traverseproc {
    public static final PyType TYPE;
    protected String name;
    protected PyType base;
    protected PyObject[] bases = Registry.EMPTY_PYOBJECT_ARRAY;
    protected PyObject dict;
    protected PyObject[] mro;
    private long tp_flags;
    protected Class<?> underlying_class;
    protected boolean builtin;
    protected boolean instantiable = true;
    boolean hasGet;
    boolean hasSet;
    boolean hasDelete;
    private boolean isBaseType = true;
    protected boolean needs_userdict;
    protected boolean needs_weakref;
    protected boolean needs_finalizer;
    private volatile boolean usesObjectGetattribute;
    private volatile Object versionTag = new Object();
    private int numSlots;
    private int ownSlots = 0;
    private transient ReferenceQueue<PyType> subclasses_refq = new ReferenceQueue();
    private Set<WeakReference<PyType>> subclasses = Generic.linkedHashSet();

    static boolean hasProxyAttr(PyObject obj) {
        return JyAttribute.hasAttr(obj, (byte)-128);
    }

    static Object getProxyAttr(PyObject obj) {
        return JyAttribute.getAttr(obj, (byte)-128);
    }

    static void setProxyAttr(PyObject obj, Object value) {
        JyAttribute.setAttr(obj, (byte)-128, value);
    }

    protected PyType(PyType subtype) {
        super(subtype);
    }

    private PyType() {
    }

    protected PyType(boolean isProxy) {
        super(false);
        this.builtin = true;
        this.underlying_class = isProxy ? null : this.getClass();
    }

    protected PyType(PyType subtype, Class<?> c) {
        super(subtype);
        this.builtin = true;
        this.underlying_class = c;
    }

    protected PyType(Class<?> c) {
        this(Constant.PYTYPE, c);
    }

    @ExposedNew
    static final PyObject type___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length == 1 && keywords.length == 0) {
            PyType psmType;
            PyObject obj = args[0];
            PyType objType = obj.getType();
            if (objType == (psmType = PyType.fromClass(PyStringMap.class))) {
                return PyDictionary.TYPE;
            }
            return objType;
        }
        if (args.length + keywords.length != 3) {
            throw Py.TypeError("type() takes 1 or 3 arguments");
        }
        ArgParser ap = new ArgParser("type()", args, keywords, "name", "bases", "dict");
        String name = ap.getString(0);
        PyTuple bases = (PyTuple)ap.getPyObjectByType(1, PyTuple.TYPE);
        PyObject dict = ap.getPyObject(2);
        if (!(dict instanceof AbstractDict)) {
            throw Py.TypeError("type(): argument 3 must be dict, not " + dict.getType());
        }
        return PyType.newType(new_, subtype, name, bases, dict);
    }

    final void type___init__(PyObject[] args, String[] kwds) {
        if (kwds.length > 0) {
            throw Py.TypeError("type.__init__() takes no keyword arguments");
        }
        if (args.length != 1 && args.length != 3) {
            throw Py.TypeError("type.__init__() takes 1 or 3 arguments");
        }
        this.object___init__(Py.EmptyObjects, Py.NoKeywords);
    }

    public static PyObject newType(PyNewWrapper new_, PyType metatype, String name, PyTuple bases, PyObject dict) {
        PyObject[] pyObjectArray;
        PyObject[] tmpBases = bases.getArray();
        PyType winner = PyType.findMostDerivedMetatype(tmpBases, metatype);
        if (winner != metatype) {
            PyObject winnerNew = winner.lookup("__new__");
            if (winnerNew != null && winnerNew != new_) {
                return PyType.invokeNew(winnerNew, winner, false, new PyObject[]{new PyString(name), bases, dict}, Py.NoKeywords);
            }
            metatype = winner;
        }
        if (metatype == PyJavaType.Constant.CLASS) {
            metatype = TYPE;
        }
        PyType type = new_.for_type == metatype ? new PyType() : new PyTypeDerived(metatype);
        dict = ((AbstractDict)dict).copy();
        type.name = name;
        if (tmpBases.length == 0) {
            PyObject[] pyObjectArray2 = new PyObject[1];
            pyObjectArray = pyObjectArray2;
            pyObjectArray2[0] = PyObject.TYPE;
        } else {
            pyObjectArray = tmpBases;
        }
        type.bases = pyObjectArray;
        type.dict = dict;
        type.tp_flags = 1536L;
        boolean defines_dict = dict.__finditem__("__dict__") != null;
        List<Class<?>> interfaces = Generic.list();
        Class<?> baseProxyClass = PyType.getJavaLayout(type.bases, interfaces);
        type.setupProxy(baseProxyClass, interfaces);
        PyType base2 = type.base = PyType.best_base(type.bases);
        if (!base2.isBaseType) {
            throw Py.TypeError(String.format("type '%.100s' is not an acceptable base type", base2.name));
        }
        type.createAllSlots(!base2.needs_userdict && !defines_dict, !base2.needs_weakref);
        type.ensureAttributes();
        type.invalidateMethodCache();
        for (PyObject cur : type.bases) {
            if (!(cur instanceof PyType)) continue;
            ((PyType)cur).attachSubclass(type);
        }
        return type;
    }

    private static int findSlottedAncestors(PyType tp, List<PyType> dest, Map<PyType, PyObject> slotsMap) {
        int baseEnd = 0;
        if (tp.base != null && tp.base.numSlots > 0 && !slotsMap.containsKey(tp.base)) {
            PyType.findSlottedAncestors(tp.base, dest, slotsMap);
        }
        baseEnd = dest.size();
        PyObject slots = tp.dict.__finditem__("__slots__");
        if (slots != null) {
            dest.add(tp);
            slotsMap.put(tp, slots);
        }
        if (tp.bases.length > 1) {
            for (PyObject base2 : tp.bases) {
                if (base2 == tp.base || !(base2 instanceof PyType) || ((PyType)base2).numSlots == 0 || slotsMap.containsKey((PyType)base2)) continue;
                PyType.findSlottedAncestors((PyType)base2, dest, slotsMap);
            }
        }
        return baseEnd;
    }

    private static void insertSlots(PyObject slots, Set<String> dest) {
        if (slots instanceof PyString) {
            slots = new PyTuple(slots);
        }
        for (PyObject slot : slots.asIterable()) {
            String slotName = PyType.confirmIdentifier(slot);
            if (slotName.equals("__dict__") || slotName.equals("__weakref__")) continue;
            dest.add(slotName);
        }
    }

    private void createAllSlots(boolean mayAddDict, boolean mayAddWeak) {
        int slotPos;
        List<PyType> slottedAncestors = Generic.list(this.base.mro.length + (this.bases.length - 1) * 3 + 1);
        Map<PyType, PyObject> slotsMap = Generic.identityHashMap(slottedAncestors.size());
        int baseEnd = PyType.findSlottedAncestors(this, slottedAncestors, slotsMap);
        int slots_tmp = 0;
        for (PyType anc : slottedAncestors) {
            slots_tmp += anc.numSlots;
        }
        Set<String> allSlots = Generic.linkedHashSet(2 * slots_tmp);
        if (baseEnd > 0) {
            for (int i = 0; i < baseEnd; ++i) {
                PyType.insertSlots(slotsMap.get(slottedAncestors.get(i)), allSlots);
            }
        }
        assert (allSlots.size() == this.base.numSlots);
        boolean wantDict = false;
        boolean wantWeak = false;
        PyObject slots = this.dict.__finditem__("__slots__");
        this.ownSlots = 0;
        if (slots == null) {
            wantDict = mayAddDict;
            wantWeak = mayAddWeak;
            slots_tmp = baseEnd;
        } else {
            if (slots instanceof PyString) {
                slots = new PyTuple(slots);
            }
            for (PyObject slot : slots.asIterable()) {
                String slotName = PyType.confirmIdentifier(slot);
                if (slotName.equals("__dict__")) {
                    if (mayAddDict && !wantDict) {
                        wantDict = true;
                        continue;
                    }
                } else if (slotName.equals("__weakref__") && (mayAddWeak && !wantWeak || this.base == PyObject.TYPE)) {
                    wantWeak = true;
                    continue;
                }
                if (!allSlots.add(slotName)) continue;
                ++this.ownSlots;
            }
            if (this.bases.length > 1 && (mayAddDict && !wantDict || mayAddWeak && !wantWeak)) {
                for (PyObject base2 : this.bases) {
                    if (base2 == this.base) continue;
                    if (base2 instanceof PyClass) {
                        if (mayAddDict && !wantDict) {
                            wantDict = true;
                        }
                        if (!mayAddWeak || wantWeak) break;
                        wantWeak = true;
                        break;
                    }
                    PyType baseType = (PyType)base2;
                    if (mayAddDict && !wantDict && baseType.needs_userdict) {
                        wantDict = true;
                    }
                    if (mayAddWeak && !wantWeak && baseType.needs_weakref) {
                        wantWeak = true;
                    }
                    if (!(mayAddDict && !wantDict || mayAddWeak && !wantWeak)) break;
                }
            }
            slots_tmp = baseEnd + 1;
        }
        for (int i = slots_tmp; i < slottedAncestors.size(); ++i) {
            PyType.insertSlots(slotsMap.get(slottedAncestors.get(i)), allSlots);
        }
        this.numSlots = allSlots.size();
        Iterator<String> slotIter = allSlots.iterator();
        for (slotPos = 0; slotPos < this.base.numSlots; ++slotPos) {
            slotIter.next();
        }
        while (slotIter.hasNext()) {
            String slotName = slotIter.next();
            if (this.dict.__finditem__(slotName = PyType.mangleName(this.name, slotName)) == null) {
                this.dict.__setitem__(slotName, (PyObject)new PySlot(this, slotName, slotPos++));
                continue;
            }
            --this.numSlots;
        }
        assert (slotPos == this.numSlots);
        if (wantDict) {
            this.createDictSlot();
        }
        if (wantWeak) {
            this.createWeakrefSlot();
        }
        this.needs_finalizer = this.needsFinalizer();
    }

    private void createDictSlot() {
        String doc = "dictionary for instance variables (if defined)";
        this.dict.__setitem__("__dict__", (PyObject)new PyDataDescr(this, "__dict__", PyObject.class, doc){

            @Override
            public boolean implementsDescrGet() {
                return true;
            }

            @Override
            public Object invokeGet(PyObject obj) {
                return obj.getDict();
            }

            @Override
            public boolean implementsDescrSet() {
                return true;
            }

            @Override
            public void invokeSet(PyObject obj, Object value) {
                obj.setDict((PyObject)value);
            }

            @Override
            public boolean implementsDescrDelete() {
                return true;
            }

            @Override
            public void invokeDelete(PyObject obj) {
                obj.delDict();
            }
        });
        this.needs_userdict = true;
    }

    private void createWeakrefSlot() {
        String doc = "list of weak references to the object (if defined)";
        this.dict.__setitem__("__weakref__", (PyObject)new PyDataDescr(this, "__weakref__", PyObject.class, doc){
            private static final String writeMsg = "attribute '%s' of '%s' objects is not writable";

            private void notWritable(PyObject obj) {
                throw Py.AttributeError(String.format(writeMsg, "__weakref__", obj.getType().fastGetName()));
            }

            @Override
            public boolean implementsDescrGet() {
                return true;
            }

            @Override
            public Object invokeGet(PyObject obj) {
                PyList weakrefs = WeakrefModule.getweakrefs(obj);
                switch (weakrefs.size()) {
                    case 0: {
                        return Py.None;
                    }
                    case 1: {
                        return weakrefs.pyget(0);
                    }
                }
                return weakrefs;
            }

            @Override
            public boolean implementsDescrSet() {
                return true;
            }

            @Override
            public void invokeSet(PyObject obj, Object value) {
                this.notWritable(obj);
            }

            @Override
            public boolean implementsDescrDelete() {
                return true;
            }

            @Override
            public void invokeDelete(PyObject obj) {
                this.notWritable(obj);
            }
        });
        this.needs_weakref = true;
    }

    private void ensureAttributes() {
        this.inheritSpecial();
        PyObject new_ = this.dict.__finditem__("__new__");
        if (new_ != null && new_ instanceof PyFunction) {
            this.dict.__setitem__("__new__", (PyObject)new PyStaticMethod(new_));
        }
        PyType.ensureDoc(this.dict);
        PyType.ensureModule(this.dict);
        this.mro_internal();
        this.cacheDescrBinds();
    }

    private void inheritSpecial() {
        if (!this.needs_userdict && this.base.needs_userdict) {
            this.needs_userdict = true;
        }
        if (!this.needs_weakref && this.base.needs_weakref) {
            this.needs_weakref = true;
        }
    }

    public static void ensureDoc(PyObject dict) {
        if (dict.__finditem__("__doc__") == null) {
            dict.__setitem__("__doc__", Py.None);
        }
    }

    public static void ensureModule(PyObject dict) {
        if (dict.__finditem__("__module__") != null) {
            return;
        }
        PyFrame frame = Py.getFrame();
        if (frame == null) {
            return;
        }
        PyObject name = frame.f_globals.__finditem__("__name__");
        if (name != null) {
            dict.__setitem__("__module__", name);
        }
    }

    private static PyObject invokeNew(PyObject new_, PyType type, boolean init, PyObject[] args, String[] keywords) {
        PyObject obj;
        if (new_ instanceof PyNewWrapper) {
            obj = ((PyNewWrapper)new_).new_impl(init, type, args, keywords);
        } else {
            int n = args.length;
            PyObject[] typePrepended = new PyObject[n + 1];
            System.arraycopy(args, 0, typePrepended, 1, n);
            typePrepended[0] = type;
            obj = new_.__get__(null, type).__call__(typePrepended, keywords);
        }
        return obj;
    }

    protected void init(Set<PyJavaType> needsInners) {
        Class<?> forClass = this.underlying_class;
        TypeBuilder builder = (TypeBuilder)Registry.classToBuilder.remove(forClass);
        if (builder == null && !Registry.deferredInit.contains(forClass)) {
            Registry.staticJavaInit(forClass);
            builder = (TypeBuilder)Registry.classToBuilder.remove(forClass);
        }
        if (builder == null) {
            Registry.deferredInit.add(forClass);
            this.computeLinearMro(PyObject.class);
        } else {
            Registry.deferredInit.remove(forClass);
            Class<?> baseClass = builder.getBase();
            if (baseClass == Object.class) {
                baseClass = this.underlying_class.getSuperclass();
            }
            this.computeLinearMro(baseClass);
            this.name = builder.getName();
            this.dict = builder.getDict(this);
            String doc = builder.getDoc();
            if (this.dict.__finditem__("__doc__") == null) {
                PyObject docObj = doc != null ? new PyString(Constant.PYSTRING, doc) : PyNone.getInstance();
                this.dict.__setitem__("__doc__", docObj);
            }
            this.setIsBaseType(builder.getIsBaseType());
            this.needs_userdict = this.dict.__finditem__("__dict__") != null;
            this.instantiable = this.dict.__finditem__("__new__") != null;
            this.cacheDescrBinds();
        }
    }

    protected void computeLinearMro(Class<?> baseClass) {
        if (this.underlying_class == PyObject.class) {
            this.mro = new PyType[1];
        } else {
            this.base = PyType.fromClass(baseClass);
            this.mro = new PyType[this.base.mro.length + 1];
            System.arraycopy(this.base.mro, 0, this.mro, 1, this.base.mro.length);
            this.bases = new PyObject[]{this.base};
        }
        this.mro[0] = this;
    }

    private void cacheDescrBinds() {
        this.hasGet = this.lookup_mro("__get__") != null;
        this.hasSet = this.lookup_mro("__set__") != null;
        this.hasDelete = this.lookup_mro("__delete__") != null;
    }

    public PyObject getStatic() {
        PyType cur = this;
        while (cur.underlying_class == null) {
            cur = cur.base;
        }
        return cur;
    }

    public final boolean needsFinalizer() {
        if (this.needs_finalizer) {
            return true;
        }
        this.needs_finalizer = this.lookup_mro("__del__") != null;
        return this.needs_finalizer;
    }

    public void compatibleForAssignment(PyType other, String attribute) {
        if (!this.getLayout().equals(other.getLayout()) || this.needs_userdict != other.needs_userdict || this.needs_finalizer != other.needs_finalizer) {
            throw Py.TypeError(String.format("%s assignment: '%s' object layout differs from '%s'", attribute, other.fastGetName(), this.fastGetName()));
        }
    }

    private PyType getLayout() {
        if (this.underlying_class != null) {
            return this;
        }
        if (this.numSlots != this.base.numSlots) {
            return this;
        }
        return this.base.getLayout();
    }

    private static Class<?> getJavaLayout(PyObject[] bases, List<Class<?>> interfaces) {
        Class<?> baseProxy = null;
        for (PyObject base2 : bases) {
            Class<?> proxy;
            if (!(base2 instanceof PyType) || (proxy = ((PyType)base2).getProxyType()) == null) continue;
            if (proxy.isInterface()) {
                interfaces.add(proxy);
                continue;
            }
            if (baseProxy != null) {
                String msg2 = "no multiple inheritance for Java classes: %s and %s";
                throw Py.TypeError(String.format(msg2, proxy.getName(), baseProxy.getName()));
            }
            baseProxy = proxy;
        }
        return baseProxy;
    }

    private void setupProxy(Class<?> baseProxyClass, List<Class<?>> interfaces) {
        if (baseProxyClass == null && interfaces.size() == 0) {
            return;
        }
        String proxyName = this.name;
        PyObject module = this.dict.__finditem__("__module__");
        if (module != null) {
            proxyName = module.toString() + "$" + proxyName;
        }
        Class<?> proxyClass = MakeProxies.makeProxy(baseProxyClass, interfaces, this.name, proxyName, this.dict);
        PyType.setProxyAttr(this, proxyClass);
        PyType proxyType = PyType.fromClass(proxyClass);
        List<PyObject> cleanedBases = Generic.list();
        boolean addedProxyType = false;
        for (PyObject base2 : this.bases) {
            if (!(base2 instanceof PyType)) {
                cleanedBases.add(base2);
                continue;
            }
            Class<?> proxy = ((PyType)base2).getProxyType();
            if (proxy == null) {
                cleanedBases.add(base2);
                continue;
            }
            if (!(base2 instanceof PyJavaType)) {
                cleanedBases.add(base2);
                continue;
            }
            if (addedProxyType) continue;
            cleanedBases.add(proxyType);
            addedProxyType = true;
        }
        this.bases = cleanedBases.toArray(new PyObject[cleanedBases.size()]);
    }

    protected PyObject richCompare(PyObject other, cmpopType op) {
        if (!(other instanceof PyType) && other != this) {
            return null;
        }
        if (this.__findattr__("__cmp__") != null || ((PyType)other).__findattr__("__cmp__") != null) {
            return null;
        }
        if (Options.py3k_warning && op != cmpopType.Eq && op != cmpopType.NotEq) {
            Py.warnPy3k("type inequality comparisons not supported in 3.x");
            return null;
        }
        int hash1 = this.object___hash__();
        int hash2 = other.object___hash__();
        switch (op) {
            case Lt: {
                return hash1 < hash2 ? Py.True : Py.False;
            }
            case LtE: {
                return hash1 <= hash2 ? Py.True : Py.False;
            }
            case Eq: {
                return hash1 == hash2 ? Py.True : Py.False;
            }
            case NotEq: {
                return hash1 != hash2 ? Py.True : Py.False;
            }
            case Gt: {
                return hash1 > hash2 ? Py.True : Py.False;
            }
            case GtE: {
                return hash1 >= hash2 ? Py.True : Py.False;
            }
        }
        return null;
    }

    public PyObject type___eq__(PyObject other) {
        return this.richCompare(other, cmpopType.Eq);
    }

    public PyObject type___ne__(PyObject other) {
        return this.richCompare(other, cmpopType.NotEq);
    }

    public PyObject type___le__(PyObject other) {
        return this.richCompare(other, cmpopType.LtE);
    }

    public PyObject type___lt__(PyObject other) {
        return this.richCompare(other, cmpopType.Lt);
    }

    public PyObject type___ge__(PyObject other) {
        return this.richCompare(other, cmpopType.GtE);
    }

    public PyObject type___gt__(PyObject other) {
        return this.richCompare(other, cmpopType.Gt);
    }

    public PyObject getBase() {
        if (this.base == null) {
            return Py.None;
        }
        return this.base;
    }

    public PyObject getBases() {
        return new PyTuple(this.bases);
    }

    public void delBases() {
        throw Py.TypeError("Can't delete __bases__ attribute");
    }

    public void setBases(PyObject newBasesTuple) {
        if (!(newBasesTuple instanceof PyTuple)) {
            throw Py.TypeError("bases must be a tuple");
        }
        PyObject[] newBases = ((PyTuple)newBasesTuple).getArray();
        if (newBases.length == 0) {
            throw Py.TypeError("can only assign non-empty tuple to __bases__, not " + newBasesTuple);
        }
        for (int i = 0; i < newBases.length; ++i) {
            if (!(newBases[i] instanceof PyType)) {
                if (newBases[i] instanceof PyClass) continue;
                throw Py.TypeError(this.name + ".__bases__ must be a tuple of old- or new-style classes, not " + newBases[i]);
            }
            if (!((PyType)newBases[i]).isSubType(this)) continue;
            throw Py.TypeError("a __bases__ item causes an inheritance cycle");
        }
        PyType newBase = PyType.best_base(newBases);
        this.base.compatibleForAssignment(newBase, "__bases__");
        PyObject[] savedBases = this.bases;
        PyType savedBase = this.base;
        PyObject[] savedMro = this.mro;
        List<Object> savedSubMros = Generic.list();
        try {
            this.bases = newBases;
            this.base = newBase;
            this.mro_internal();
            this.mro_subclasses(savedSubMros);
            for (PyObject saved : savedBases) {
                if (!(saved instanceof PyType)) continue;
                ((PyType)saved).detachSubclass(this);
            }
            for (PyObject newb : newBases) {
                if (!(newb instanceof PyType)) continue;
                ((PyType)newb).attachSubclass(this);
            }
        }
        catch (PyException t) {
            Iterator it = savedSubMros.iterator();
            while (it.hasNext()) {
                PyType subtype = (PyType)it.next();
                PyObject[] subtypeSavedMro = (PyObject[])it.next();
                subtype.mro = subtypeSavedMro;
            }
            this.bases = savedBases;
            this.base = savedBase;
            this.mro = savedMro;
            throw t;
        }
        this.postSetattr("__getattribute__");
    }

    private void setIsBaseType(boolean isBaseType) {
        this.isBaseType = isBaseType;
        this.tp_flags = isBaseType ? this.tp_flags | 0x400L : this.tp_flags & 0xFFFFFFFFFFFFFBFFL;
    }

    boolean isAbstract() {
        return (this.tp_flags & 0x100000L) != 0L;
    }

    private void mro_internal() {
        if (this.getType() == TYPE) {
            this.mro = this.computeMro();
        } else {
            PyObject mroDescr = this.getType().lookup("mro");
            if (mroDescr == null) {
                throw Py.AttributeError("mro");
            }
            PyObject[] result2 = Py.make_array(mroDescr.__get__(null, this.getType()).__call__(this));
            PyType solid = PyType.solid_base(this);
            for (PyObject cls : result2) {
                if (cls instanceof PyClass) continue;
                if (cls instanceof PyType) {
                    PyType t = (PyType)cls;
                    if (solid.isSubType(PyType.solid_base(t))) continue;
                    String fmt = "mro() returned base with unsuitable layout ('%.500s')";
                    throw Py.TypeError(String.format(fmt, t.fastGetName()));
                }
                String fmt = "mro() returned a non-class ('%.500s')";
                throw Py.TypeError(String.format(fmt, cls.getType().fastGetName()));
            }
            this.mro = result2;
        }
    }

    private void mro_subclasses(List<Object> mroCollector) {
        for (WeakReference<PyType> ref : this.subclasses) {
            PyType subtype = (PyType)ref.get();
            if (subtype == null) continue;
            mroCollector.add(subtype);
            mroCollector.add(subtype.mro);
            subtype.mro_internal();
            subtype.mro_subclasses(mroCollector);
        }
    }

    public PyObject instDict() {
        if (this.needs_userdict) {
            return new PyStringMap();
        }
        return null;
    }

    private void cleanup_subclasses() {
        Reference<PyType> ref;
        while ((ref = this.subclasses_refq.poll()) != null) {
            this.subclasses.remove(ref);
        }
    }

    public PyTuple getMro() {
        return this.mro == null ? Py.EmptyTuple : new PyTuple(this.mro);
    }

    public PyLong getFlags() {
        return new PyLong(this.tp_flags);
    }

    public final synchronized PyObject type___subclasses__() {
        PyList result2 = new PyList();
        this.cleanup_subclasses();
        for (WeakReference<PyType> ref : this.subclasses) {
            PyType subtype = (PyType)ref.get();
            if (subtype == null) continue;
            result2.append(subtype);
        }
        return result2;
    }

    public final synchronized boolean type___subclasscheck__(PyObject inst) {
        return Py.recursiveIsSubClass(inst, this);
    }

    public final synchronized boolean type___instancecheck__(PyObject inst) {
        if (inst.getType() == this) {
            return true;
        }
        return Py.recursiveIsInstance(inst, this);
    }

    public Class<?> getProxyType() {
        return (Class)PyType.getProxyAttr(this);
    }

    private synchronized void attachSubclass(PyType subtype) {
        this.cleanup_subclasses();
        this.subclasses.add(new WeakReference<PyType>(subtype, this.subclasses_refq));
    }

    private synchronized void detachSubclass(PyType subtype) {
        this.cleanup_subclasses();
        for (WeakReference<PyType> ref : this.subclasses) {
            if (ref.get() != subtype) continue;
            this.subclasses.remove(ref);
            break;
        }
    }

    private synchronized void traverse_hierarchy(boolean top, OnType behavior) {
        boolean stop = false;
        if (!top) {
            stop = behavior.onType(this);
        }
        if (stop) {
            return;
        }
        for (WeakReference<PyType> ref : this.subclasses) {
            PyType subtype = (PyType)ref.get();
            if (subtype == null) continue;
            subtype.traverse_hierarchy(false, behavior);
        }
    }

    private static void fill_classic_mro(List<PyObject> acc, PyClass classic_cl) {
        PyObject[] bases;
        if (!acc.contains(classic_cl)) {
            acc.add(classic_cl);
        }
        for (PyObject base2 : bases = classic_cl.__bases__.getArray()) {
            PyType.fill_classic_mro(acc, (PyClass)base2);
        }
    }

    private static PyObject[] classic_mro(PyClass classic_cl) {
        List<PyObject> acc = Generic.list();
        PyType.fill_classic_mro(acc, classic_cl);
        return acc.toArray(new PyObject[acc.size()]);
    }

    final PyList type_mro(PyObject X) {
        PyObject[] res = X == null ? this.computeMro() : ((PyType)X).computeMro();
        return new PyList(res);
    }

    PyObject[] computeMro() {
        for (int i = 0; i < this.bases.length; ++i) {
            PyObject cur = this.bases[i];
            for (int j = i + 1; j < this.bases.length; ++j) {
                if (this.bases[j] != cur) continue;
                PyObject name = cur.__findattr__("__name__");
                throw Py.TypeError("duplicate base class " + (name == null ? "?" : name.toString()));
            }
        }
        MROMergeState[] toMerge = new MROMergeState[this.bases.length + 1];
        for (int i = 0; i < this.bases.length; ++i) {
            toMerge[i] = new MROMergeState();
            if (this.bases[i] instanceof PyType) {
                toMerge[i].mro = ((PyType)this.bases[i]).mro;
                continue;
            }
            if (!(this.bases[i] instanceof PyClass)) continue;
            toMerge[i].mro = PyType.classic_mro((PyClass)this.bases[i]);
        }
        toMerge[this.bases.length] = new MROMergeState();
        toMerge[this.bases.length].mro = this.bases;
        List<PyObject> mro = Generic.list();
        mro.add(this);
        return this.computeMro(toMerge, mro);
    }

    PyObject[] computeMro(MROMergeState[] toMerge, List<PyObject> mro) {
        boolean addedProxy = false;
        Class<?> thisProxyAttr = this.getProxyType();
        PyType proxyAsType = thisProxyAttr == null ? null : PyType.fromClass(thisProxyAttr);
        block0: for (int i = 0; i < toMerge.length; ++i) {
            Class<?> candidateProxyAttr;
            if (toMerge[i].isMerged()) continue;
            PyObject candidate = toMerge[i].getCandidate();
            for (MROMergeState mergee : toMerge) {
                if (mergee.pastnextContains(candidate)) continue block0;
            }
            if (!addedProxy && !(this instanceof PyJavaType) && candidate instanceof PyJavaType && (candidateProxyAttr = ((PyJavaType)candidate).getProxyType()) != null && PyProxy.class.isAssignableFrom(candidateProxyAttr) && candidateProxyAttr != thisProxyAttr) {
                mro.add(proxyAsType);
                addedProxy = true;
            }
            mro.add(candidate);
            addedProxy |= candidate == proxyAsType;
            for (MROMergeState element : toMerge) {
                element.noteMerged(candidate);
            }
            i = -1;
        }
        for (MROMergeState mergee : toMerge) {
            if (mergee.isMerged()) continue;
            this.handleMroError(toMerge, mro);
        }
        return mro.toArray(new PyObject[mro.size()]);
    }

    void handleMroError(MROMergeState[] toMerge, List<PyObject> mro) {
        StringBuilder msg2 = new StringBuilder("Cannot create a consistent method resolution\norder (MRO) for bases ");
        Set<PyObject> set = Generic.set();
        for (MROMergeState mergee : toMerge) {
            if (mergee.isMerged()) continue;
            set.add(mergee.mro[0]);
        }
        boolean first = true;
        for (PyObject unmerged : set) {
            PyObject name = unmerged.__findattr__("__name__");
            if (first) {
                first = false;
            } else {
                msg2.append(", ");
            }
            msg2.append(name == null ? "?" : name.toString() + new PyList(((PyType)unmerged).bases));
        }
        throw Py.TypeError(msg2.toString());
    }

    private static PyType solid_base(PyType type) {
        do {
            if (!PyType.isSolidBase(type)) continue;
            return type;
        } while ((type = type.base) != null);
        return PyObject.TYPE;
    }

    private static boolean isSolidBase(PyType type) {
        return type.underlying_class != null || type.ownSlots != 0 && !type.needs_userdict;
    }

    private static PyType best_base(PyObject[] bases) {
        PyType best = null;
        PyType bestSolid = null;
        for (PyObject b : bases) {
            if (b instanceof PyType) {
                PyType base2 = (PyType)b;
                PyType solid = PyType.solid_base(base2);
                if (bestSolid == null) {
                    best = base2;
                    bestSolid = solid;
                    continue;
                }
                if (bestSolid.isSubType(solid)) continue;
                if (solid.isSubType(bestSolid)) {
                    best = base2;
                    bestSolid = solid;
                    continue;
                }
                throw Py.TypeError("multiple bases have instance lay-out conflict");
            }
            if (b instanceof PyClass) continue;
            throw Py.TypeError("bases must be types");
        }
        if (best == null) {
            throw Py.TypeError("a new-style class can't have only classic bases");
        }
        return best;
    }

    private static boolean isJavaRootClass(PyType type) {
        return type instanceof PyJavaType && type.fastGetName().equals("java.lang.Class");
    }

    private static PyType findMostDerivedMetatype(PyObject[] bases_list, PyType initialMetatype) {
        PyType winner = initialMetatype;
        if (PyType.isJavaRootClass(winner)) {
            winner = TYPE;
        }
        for (PyObject base2 : bases_list) {
            if (base2 instanceof PyClass) continue;
            PyType curtype = base2.getType();
            if (PyType.isJavaRootClass(curtype)) {
                curtype = TYPE;
            }
            if (winner.isSubType(curtype)) continue;
            if (curtype.isSubType(winner)) {
                winner = curtype;
                continue;
            }
            throw Py.TypeError("metaclass conflict: the metaclass of a derived class must be a (non-strict) subclass of the metaclasses of all its bases");
        }
        return winner;
    }

    public boolean isSubType(PyType supertype) {
        if (this.mro != null) {
            for (PyObject base2 : this.mro) {
                if (base2 != supertype) continue;
                return true;
            }
            return false;
        }
        PyType type = this;
        do {
            if (type != supertype) continue;
            return true;
        } while ((type = type.base) != null);
        return supertype == PyObject.TYPE;
    }

    public PyObject lookup(String name) {
        return this.lookup_where(name, null);
    }

    protected PyObject lookup_mro(String name) {
        return this.lookup_where_mro(name, null);
    }

    public PyObject lookup_where(String name, PyObject[] where) {
        return MethodCache.methodCache.lookup_where(this, name, where);
    }

    protected PyObject lookup_where_mro(String name, PyObject[] where) {
        PyObject[] mro = this.mro;
        if (mro == null) {
            return null;
        }
        for (PyObject t : mro) {
            PyObject obj;
            PyObject dict = t.fastGetDict();
            if (dict == null || (obj = dict.__finditem__(name)) == null) continue;
            if (where != null) {
                where[0] = t;
            }
            return obj;
        }
        return null;
    }

    public PyObject super_lookup(PyType ref, String name) {
        int i;
        PyObject[] mro = this.mro;
        if (mro == null) {
            return null;
        }
        for (i = 0; i < mro.length && mro[i] != ref; ++i) {
        }
        ++i;
        while (i < mro.length) {
            PyObject obj;
            String lookupName = mro[i] instanceof PyJavaType ? (name != "__init__" && !name.startsWith("super__") ? "super__" + name : name) : name;
            PyObject dict = mro[i].fastGetDict();
            if (dict != null && (obj = dict.__finditem__(lookupName)) != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public static void addBuilder(Class<?> c, TypeBuilder builder) {
        Registry.addBuilder(c, builder);
    }

    public static synchronized boolean ensureBootstrapped() {
        Set<Class<?>> missing = Registry.bootstrap();
        if (!missing.isEmpty()) {
            Py.writeWarning("init", "Bootstrap types weren't encountered in bootstrapping: " + missing + "\nThis may be caused by compiled core classes preceding their exposed equivalents on the class path.");
            return false;
        }
        return true;
    }

    public static PyType fromClass(Class<?> c, boolean hardRef) {
        return PyType.fromClass(c);
    }

    public static PyType fromClass(Class<?> c) {
        try {
            return Registry.classToType.get(c);
        }
        catch (Registry.IncompleteType it) {
            return it.type;
        }
    }

    final PyObject type___getattribute__(PyObject name) {
        String n = PyType.asName(name);
        PyObject ret = this.type___findattr_ex__(n);
        if (ret == null) {
            this.noAttributeError(n);
        }
        return ret;
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        return this.type___findattr_ex__(name);
    }

    final PyObject type___findattr_ex__(String name) {
        PyObject res;
        PyObject attr;
        PyType metatype = this.getType();
        PyObject metaattr = metatype.lookup(name);
        boolean get = false;
        if (metaattr != null) {
            PyObject res2;
            get = metaattr.implementsDescrGet();
            if (this.useMetatypeFirst(metaattr) && get && metaattr.isDataDescr() && (res2 = metaattr.__get__(this, metatype)) != null) {
                return res2;
            }
        }
        if ((attr = this.lookup(name)) != null && (res = attr.__get__(null, this)) != null) {
            return res;
        }
        if (get) {
            return metaattr.__get__(this, metatype);
        }
        if (metaattr != null) {
            return metaattr;
        }
        return null;
    }

    protected boolean useMetatypeFirst(PyObject attr) {
        return true;
    }

    final void type___setattr__(PyObject name, PyObject value) {
        this.type___setattr__(PyType.asName(name), value);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        this.type___setattr__(name, value);
    }

    public void addMethod(PyBuiltinMethod meth) {
        PyMethodDescr pmd = meth.makeDescriptor(this);
        this.__setattr__(pmd.getName(), (PyObject)pmd);
    }

    public void removeMethod(PyBuiltinMethod meth) {
        this.__delattr__(meth.info.getName());
    }

    void type___setattr__(String name, PyObject value) {
        if (this.builtin) {
            throw Py.TypeError(String.format("can't set attributes of built-in/extension type '%s'", this.name));
        }
        super.__setattr__(name, value);
        this.postSetattr(name);
    }

    void postSetattr(String name) {
        this.invalidateMethodCache();
        if (name == "__get__") {
            if (!this.hasGet && this.lookup("__get__") != null) {
                this.traverse_hierarchy(false, new OnType(){

                    @Override
                    public boolean onType(PyType type) {
                        boolean old = type.hasGet;
                        type.hasGet = true;
                        return old;
                    }
                });
            }
        } else if (name == "__set__") {
            if (!this.hasSet && this.lookup("__set__") != null) {
                this.traverse_hierarchy(false, new OnType(){

                    @Override
                    public boolean onType(PyType type) {
                        boolean old = type.hasSet;
                        type.hasSet = true;
                        return old;
                    }
                });
            }
        } else if (name == "__delete__") {
            if (!this.hasDelete && this.lookup("__delete__") != null) {
                this.traverse_hierarchy(false, new OnType(){

                    @Override
                    public boolean onType(PyType type) {
                        boolean old = type.hasDelete;
                        type.hasDelete = true;
                        return old;
                    }
                });
            }
        } else if (name == "__getattribute__") {
            this.traverse_hierarchy(false, new OnType(){

                @Override
                public boolean onType(PyType type) {
                    return type.usesObjectGetattribute = false;
                }
            });
        }
    }

    @Override
    public void __delattr__(String name) {
        this.type___delattr__(name);
    }

    final void type___delattr__(PyObject name) {
        this.type___delattr__(PyType.asName(name));
    }

    protected void checkDelattr() {
    }

    void type___delattr__(String name) {
        if (this.builtin) {
            throw Py.TypeError(String.format("can't set attributes of built-in/extension type '%s'", this.name));
        }
        super.__delattr__(name);
        this.postDelattr(name);
    }

    void postDelattr(String name) {
        this.invalidateMethodCache();
        if (name == "__get__") {
            if (this.hasGet && this.lookup("__get__") == null) {
                this.traverse_hierarchy(false, new OnType(){

                    @Override
                    public boolean onType(PyType type) {
                        boolean absent;
                        boolean bl = absent = type.getDict().__finditem__("__get__") == null;
                        if (absent) {
                            type.hasGet = false;
                            return false;
                        }
                        return true;
                    }
                });
            }
        } else if (name == "__set__") {
            if (this.hasSet && this.lookup("__set__") == null) {
                this.traverse_hierarchy(false, new OnType(){

                    @Override
                    public boolean onType(PyType type) {
                        boolean absent;
                        boolean bl = absent = type.getDict().__finditem__("__set__") == null;
                        if (absent) {
                            type.hasSet = false;
                            return false;
                        }
                        return true;
                    }
                });
            }
        } else if (name == "__delete__") {
            if (this.hasDelete && this.lookup("__delete__") == null) {
                this.traverse_hierarchy(false, new OnType(){

                    @Override
                    public boolean onType(PyType type) {
                        boolean absent;
                        boolean bl = absent = type.getDict().__finditem__("__delete__") == null;
                        if (absent) {
                            type.hasDelete = false;
                            return false;
                        }
                        return true;
                    }
                });
            }
        } else if (name == "__getattribute__") {
            this.traverse_hierarchy(false, new OnType(){

                @Override
                public boolean onType(PyType type) {
                    return type.usesObjectGetattribute = false;
                }
            });
        }
    }

    protected void invalidateMethodCache() {
        this.traverse_hierarchy(false, new OnType(){

            @Override
            public boolean onType(PyType type) {
                type.versionTag = new Object();
                return false;
            }
        });
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.type___call__(args, keywords);
    }

    final PyObject type___call__(PyObject[] args, String[] keywords) {
        PyObject new_ = this.lookup("__new__");
        if (!this.instantiable || new_ == null) {
            throw Py.TypeError(String.format("cannot create '%.100s' instances", this.name));
        }
        PyObject obj = PyType.invokeNew(new_, this, true, args, keywords);
        if (this == TYPE && args.length == 1 && keywords.length == 0 || !obj.getType().isSubType(this)) {
            return obj;
        }
        obj.dispatch__init__(args, keywords);
        return obj;
    }

    @Override
    protected void __rawdir__(PyDictionary accum) {
        this.mergeClassDict(accum, this);
    }

    public String fastGetName() {
        return this.name;
    }

    public PyObject pyGetName() {
        return Py.newString(this.getName());
    }

    public String getName() {
        if (!this.builtin) {
            return this.name;
        }
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot != -1) {
            return this.name.substring(lastDot + 1);
        }
        return this.name;
    }

    public void pySetName(PyObject name) {
        if (!(name instanceof PyString)) {
            throw Py.TypeError(String.format("can only assign string to %s.__name__, not '%s'", this.name, name.getType().fastGetName()));
        }
        String nameStr = name.toString();
        if (nameStr.indexOf(0) > -1) {
            throw Py.ValueError("__name__ must not contain null bytes");
        }
        this.setName(nameStr);
        this.invalidateMethodCache();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void pyDelName() {
        throw Py.TypeError(String.format("can't delete %s.__name__", this.name));
    }

    @Override
    public PyObject fastGetDict() {
        return this.dict;
    }

    @Override
    public PyObject getDict() {
        return new PyDictProxy(this.dict);
    }

    @Override
    public void setDict(PyObject newDict) {
        throw Py.AttributeError(String.format("attribute '__dict__' of '%s' objects is not writable", this.getType().fastGetName()));
    }

    @Override
    public void delDict() {
        this.setDict(null);
    }

    public PyObject getDoc() {
        PyObject doc = this.dict.__finditem__("__doc__");
        if (doc == null) {
            return Py.None;
        }
        return doc.__get__(null, this);
    }

    boolean getUsesObjectGetattribute() {
        return this.usesObjectGetattribute;
    }

    void setUsesObjectGetattribute(boolean usesObjectGetattribute) {
        this.usesObjectGetattribute = usesObjectGetattribute;
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (this.underlying_class != null && (c == Object.class || c == Class.class || c == Serializable.class)) {
            return this.underlying_class;
        }
        return super.__tojava__(c);
    }

    public PyObject getModule() {
        if (!this.builtin) {
            return this.dict.__finditem__("__module__");
        }
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot != -1) {
            return new PyString(this.name.substring(0, lastDot));
        }
        return new PyString("__builtin__");
    }

    public void delModule() {
        throw Py.TypeError(String.format("can't delete %s.__module__", this.name));
    }

    public PyObject getAbstractmethods() {
        PyObject result2 = this.dict.__finditem__("__abstractmethods__");
        if (result2 == null || result2 instanceof PyDataDescr) {
            this.noAttributeError("__abstractmethods__");
        }
        return result2;
    }

    public void setAbstractmethods(PyObject value) {
        this.dict.__setitem__("__abstractmethods__", value);
        this.postSetattr("__abstractmethods__");
        this.tp_flags = value.__nonzero__() ? this.tp_flags | 0x100000L : this.tp_flags & 0xFFFFFFFFFFEFFFFFL;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    final String type_toString() {
        String kind;
        String string2 = kind = this.builtin ? "type" : "class";
        if (this.name == null || !this.builtin && this.dict == null) {
            return String.format("<%s '%s'>", this.getClass().getSimpleName(), this.underlying_class);
        }
        if (Registry.deferredInit.contains(PyString.class)) {
            return String.format("<%s ... '%s'>", kind, this.name);
        }
        PyObject module = this.getModule();
        if (module instanceof PyString && !module.toString().equals("__builtin__")) {
            return String.format("<%s '%s.%s'>", kind, module.toString(), this.getName());
        }
        return String.format("<%s '%s'>", kind, this.getName());
    }

    @Override
    public String toString() {
        return this.type_toString();
    }

    @Override
    public void noAttributeError(String name) {
        throw Py.AttributeError(String.format("type object '%.50s' has no attribute '%.400s'", this.fastGetName(), name));
    }

    private static String confirmIdentifier(PyObject obj) {
        if (!(obj instanceof PyString)) {
            throw Py.TypeError(String.format("__slots__ items must be strings, not '%.200s'", obj.getType().fastGetName()));
        }
        String identifier = obj instanceof PyUnicode ? ((PyUnicode)obj).encode() : obj.toString();
        String msg2 = "__slots__ must be identifiers";
        if (identifier.length() == 0 || !Character.isLetter(identifier.charAt(0)) && identifier.charAt(0) != '_') {
            throw Py.TypeError(msg2);
        }
        for (char c : identifier.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw Py.TypeError(msg2);
        }
        return identifier;
    }

    private static String mangleName(String classname, String methodname) {
        if (classname != null && methodname.startsWith("__") && !methodname.endsWith("__")) {
            int i = 0;
            while (classname.charAt(i) == '_') {
                ++i;
            }
            return ("_" + classname.substring(i) + methodname).intern();
        }
        return methodname;
    }

    protected Object writeReplace() {
        return new TypeResolver(this.underlying_class, this.getModule().toString(), this.getName());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.base != null && (retVal = visit.visit(this.base, arg)) != 0) {
            return retVal;
        }
        for (PyObject ob : this.bases) {
            if (ob == null || (retVal = visit.visit(ob, arg)) == 0) continue;
            return retVal;
        }
        if (this.dict != null && (retVal = visit.visit(this.dict, arg)) != 0) {
            return retVal;
        }
        if (this.mro != null) {
            for (PyObject ob : this.mro) {
                retVal = visit.visit(ob, arg);
                if (retVal == 0) continue;
                return retVal;
            }
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
        if (ob == null) {
            return false;
        }
        for (PyObject obj : this.bases) {
            if (obj != ob) continue;
            return true;
        }
        if (this.mro != null) {
            for (PyObject obj : this.mro) {
                if (obj != ob) continue;
                return true;
            }
        }
        return ob == this.base || ob == this.dict;
    }

    static {
        PyType.addBuilder(PyType.class, new PyType$PyExposer());
        TYPE = PyType.fromClass(PyType.class);
    }

    static class MethodCache {
        private static final MethodCache methodCache = new MethodCache();
        private final AtomicReferenceArray<MethodCacheEntry> table = new AtomicReferenceArray(4096);
        private static final int SIZE_EXP = 12;

        public MethodCache() {
            this.clear();
        }

        public void clear() {
            int length = this.table.length();
            for (int i = 0; i < length; ++i) {
                this.table.set(i, MethodCacheEntry.EMPTY);
            }
        }

        public PyObject lookup_where(PyType type, String name, PyObject[] where) {
            Object versionTag = type.versionTag;
            int index = MethodCache.indexFor(versionTag, name);
            MethodCacheEntry entry = this.table.get(index);
            if (entry.isValid(versionTag, name)) {
                return entry.get(where);
            }
            if (where == null) {
                where = new PyObject[1];
            }
            PyObject value = type.lookup_where_mro(name, where);
            if (MethodCache.isCacheableName(name)) {
                this.table.compareAndSet(index, entry, new MethodCacheEntry(versionTag, name, where[0], value));
            }
            return value;
        }

        private static int indexFor(Object version2, String name) {
            return (version2.hashCode() ^ name.hashCode()) & 0xFFF;
        }

        private static boolean isCacheableName(String name) {
            return name.length() <= 100;
        }

        static class MethodCacheEntry
        extends WeakReference<PyObject> {
            private final Object version;
            private final String name;
            private final WeakReference<PyObject> where;
            static final MethodCacheEntry EMPTY = new MethodCacheEntry();

            private MethodCacheEntry() {
                this(null, null, null, null);
            }

            public MethodCacheEntry(Object version2, String name, PyObject where, PyObject value) {
                super(value);
                this.version = version2;
                this.name = name;
                this.where = new WeakReference<PyObject>(where);
            }

            public boolean isValid(Object version2, String name) {
                return this.version == version2 && this.name == name;
            }

            public PyObject get(PyObject[] where) {
                if (where != null) {
                    where[0] = (PyObject)this.where.get();
                }
                return (PyObject)this.get();
            }
        }
    }

    static class MROMergeState {
        public PyObject[] mro;
        public int next;

        MROMergeState() {
        }

        public boolean isMerged() {
            return this.mro.length == this.next;
        }

        public PyObject getCandidate() {
            return this.mro[this.next];
        }

        public void noteMerged(PyObject candidate) {
            if (!this.isMerged() && this.getCandidate() == candidate) {
                ++this.next;
            }
        }

        public boolean pastnextContains(PyObject candidate) {
            for (int i = this.next + 1; i < this.mro.length; ++i) {
                if (this.mro[i] != candidate) continue;
                return true;
            }
            return false;
        }

        public void removeFromUnmerged(PyJavaType winner) {
            if (this.isMerged()) {
                return;
            }
            List<PyObject> newMro = Generic.list();
            for (PyObject mroEntry : this.mro) {
                if (mroEntry == winner) continue;
                newMro.add(mroEntry);
            }
            this.mro = newMro.toArray(new PyObject[newMro.size()]);
        }

        public String toString() {
            List names = Generic.list();
            for (int i = this.next; i < this.mro.length; ++i) {
                PyObject t = this.mro[i];
                if (t instanceof PyType) {
                    names.add(((PyType)t).name);
                    continue;
                }
                names.add(t.toString());
            }
            return names.toString();
        }
    }

    static class TypeResolver
    implements Serializable {
        private Class<?> underlying_class;
        String module;
        private String name;

        TypeResolver(Class<?> underlying_class, String module, String name) {
            if (underlying_class != null && !PyProxy.class.isAssignableFrom(underlying_class)) {
                this.underlying_class = underlying_class;
            }
            this.module = module;
            this.name = name;
        }

        private Object readResolve() {
            if (this.underlying_class != null) {
                return PyType.fromClass(this.underlying_class);
            }
            PyObject mod2 = imp.importName(this.module.intern(), false);
            PyObject pytyp = mod2.__getattr__(this.name.intern());
            if (!(pytyp instanceof PyType)) {
                throw Py.TypeError(this.module + "." + this.name + " must be a type for deserialization");
            }
            return pytyp;
        }
    }

    private static interface OnType {
        public boolean onType(PyType var1);
    }

    private static final class Registry {
        private static final Map<Class<?>, PyType> classToNewType = new IdentityHashMap();
        private static final Map<Class<?>, TypeBuilder> classToBuilder = new HashMap();
        static ClassValue<PyType> classToType = new ClassValue<PyType>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected PyType computeValue(Class<?> c) throws IncompleteType {
                Class<Registry> clazz = Registry.class;
                synchronized (Registry.class) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return Registry.resolveType(c);
                }
            }
        };
        private static final Map<Class<?>, PyType> classToThrownType = new IdentityHashMap();
        private static final Class<?>[] BOOTSTRAP_TYPES = new Class[]{PyObject.class, PyType.class, PyBuiltinCallable.class, PyDataDescr.class, PyString.class};
        static final Set<Class<?>> deferredInit = new HashSet(Arrays.asList(BOOTSTRAP_TYPES));
        private static int depth = 0;
        private static Set<PyJavaType> needsInners = new HashSet<PyJavaType>();
        static final PyObject[] EMPTY_PYOBJECT_ARRAY = new PyObject[0];
        private static final String PAD = "                              ";

        private Registry() {
        }

        private static boolean isExposed(Class<?> c) {
            if (c.getAnnotation(ExposedType.class) != null) {
                return true;
            }
            return ExposeAsSuperclass.class.isAssignableFrom(c);
        }

        static PyType resolveType(Class<?> c) throws IncompleteType {
            PyType type = classToNewType.get(c);
            if (type != null) {
                classToThrownType.put(c, type);
                throw new IncompleteType(type);
            }
            type = classToThrownType.remove(c);
            if (type == null) {
                if (depth > 0) {
                    ++depth;
                    Registry.addFromClass(c);
                    --depth;
                    type = classToNewType.remove(c);
                } else {
                    assert (needsInners.isEmpty());
                    try {
                        depth = 1;
                        Registry.addFromClass(c);
                        if (!needsInners.isEmpty()) {
                            Registry.processInners();
                        }
                    }
                    finally {
                        depth = 0;
                        needsInners.clear();
                    }
                    type = classToNewType.remove(c);
                }
            }
            return type;
        }

        private static void processInners() {
            PyJavaType[] ni = needsInners.toArray(new PyJavaType[needsInners.size()]);
            depth = 0;
            needsInners.clear();
            for (PyJavaType javaType : ni) {
                Class<?> forClass = javaType.getProxyType();
                for (Class<?> inner : forClass.getClasses()) {
                    if (inner.getDeclaringClass() != forClass || javaType.dict.__finditem__(inner.getSimpleName()) != null) continue;
                    PyType innerType = PyType.fromClass(inner);
                    javaType.dict.__setitem__(inner.getSimpleName(), (PyObject)innerType);
                }
            }
        }

        private static void addFromClass(Class<?> c) {
            if (ExposeAsSuperclass.class.isAssignableFrom(c)) {
                PyType exposedAs = PyType.fromClass(c.getSuperclass());
                classToNewType.put(c, exposedAs);
            } else {
                Registry.createType(c);
            }
        }

        private static void createType(Class<?> c) {
            PyType newtype = PyObject.class.isAssignableFrom(c) ? (Registry.isExposed(c) ? (c != PyType.class ? new PyType(c) : Constant.PYTYPE) : new PyJavaType(c, true)) : (c != Class.class ? new PyJavaType(c, false) : PyJavaType.Constant.CLASS);
            classToNewType.put(c, newtype);
            newtype.init(needsInners);
            newtype.invalidateMethodCache();
        }

        static synchronized void addBuilder(Class<?> c, TypeBuilder builder) {
            classToBuilder.put(c, builder);
            PyType type = PyType.fromClass(c);
            if (deferredInit.remove(c)) {
                type.init(null);
            }
        }

        static synchronized void staticJavaInit(Class<?> c) throws SecurityException {
            try {
                Class.forName(c.getName(), true, c.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String msg2 = "Got ClassNotFound calling Class.forName on a class already found ";
                throw new RuntimeException(msg2, e);
            }
            catch (ExceptionInInitializerError e) {
                throw Py.JavaError(e);
            }
        }

        static synchronized Set<Class<?>> bootstrap() {
            HashSet missing = new HashSet();
            for (Class<?> c : BOOTSTRAP_TYPES) {
                PyType type = PyType.fromClass(c);
                if (deferredInit.contains(c)) {
                    Registry.staticJavaInit(c);
                }
                if (type.name != null && !deferredInit.contains(c)) continue;
                missing.add(c);
            }
            return missing;
        }

        private static void log(String where, Class<?> c) {
            String name = Registry.abbr(c.getName());
            System.err.printf("%s%s: %s %s thr=%s\n", Registry.pad(), where, name, Registry.names(classToNewType), Registry.names(classToThrownType));
        }

        private static void log(String kind, PyType result2) {
            String r = result2.toString();
            System.err.printf("%s%s %s %s thr=%s\n", Registry.pad(), kind, r, Registry.names(classToNewType), Registry.names(classToThrownType));
        }

        private static String abbr(String name) {
            return name.replace("java.lang.", "j.l.").replace("org.python27.core.", "");
        }

        private static String pad() {
            int d = Math.min(Math.max(2 * depth, 0), PAD.length());
            return PAD.substring(0, d);
        }

        private static List<String> names(Map<Class<?>, PyType> map) {
            ArrayList<String> names = new ArrayList<String>(map.size());
            for (Class<?> k : map.keySet()) {
                names.add(Registry.abbr(k.getName()));
            }
            return names;
        }

        private static class IncompleteType
        extends RuntimeException {
            final PyType type;

            IncompleteType(PyType type) {
                this.type = type;
            }
        }
    }

    protected static class Constant {
        static final PyType PYTYPE = new PyType(false);
        static final PyType PYOBJECT = PyType.fromClass(PyObject.class);
        static final PyType PYSTRING = PyType.fromClass(PyString.class);

        protected Constant() {
        }
    }
}

