/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.adapter;

import java.math.BigInteger;
import org.python27.core.Py;
import org.python27.core.PyArray;
import org.python27.core.PyFloat;
import org.python27.core.PyInteger;
import org.python27.core.PyJavaType;
import org.python27.core.PyLong;
import org.python27.core.PyObject;
import org.python27.core.PyProxy;
import org.python27.core.PyType;
import org.python27.core.PyUnicode;
import org.python27.core.adapter.ClassAdapter;
import org.python27.core.adapter.ExtensiblePyObjectAdapter;
import org.python27.core.adapter.PyObjectAdapter;

public class ClassicPyObjectAdapter
extends ExtensiblePyObjectAdapter {
    public ClassicPyObjectAdapter() {
        this.addPreClass(new PyObjectAdapter(){

            @Override
            public PyObject adapt(Object o) {
                return (PyObject)o;
            }

            @Override
            public boolean canAdapt(Object o) {
                return o instanceof PyObject;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            @Override
            public PyObject adapt(Object o) {
                return ((PyProxy)o)._getPyInstance();
            }

            @Override
            public boolean canAdapt(Object o) {
                return o instanceof PyProxy;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            @Override
            public boolean canAdapt(Object o) {
                return o == null;
            }

            @Override
            public PyObject adapt(Object o) {
                return Py.None;
            }
        });
        this.add(new ClassAdapter(String.class){

            @Override
            public PyObject adapt(Object o) {
                return new PyUnicode((String)o);
            }
        });
        this.add(new ClassAdapter(Character.class){

            @Override
            public PyObject adapt(Object o) {
                return Py.makeCharacter((Character)o);
            }
        });
        this.add(new ClassAdapter(Class.class){

            @Override
            public PyObject adapt(Object o) {
                return PyType.fromClass((Class)o, false);
            }
        });
        this.add(new NumberToPyFloat(Double.class));
        this.add(new NumberToPyFloat(Float.class));
        this.add(new NumberToPyInteger(Integer.class));
        this.add(new NumberToPyInteger(Byte.class));
        this.add(new NumberToPyInteger(Short.class));
        this.add(new ClassAdapter(Long.class){

            @Override
            public PyObject adapt(Object o) {
                return new PyLong(((Number)o).longValue());
            }
        });
        this.add(new ClassAdapter(BigInteger.class){

            @Override
            public PyObject adapt(Object o) {
                return new PyLong((BigInteger)o);
            }
        });
        this.add(new ClassAdapter(Boolean.class){

            @Override
            public PyObject adapt(Object o) {
                return (Boolean)o != false ? Py.True : Py.False;
            }
        });
        this.addPostClass(new PyObjectAdapter(){

            @Override
            public PyObject adapt(Object o) {
                return new PyArray(o.getClass().getComponentType(), o);
            }

            @Override
            public boolean canAdapt(Object o) {
                return o.getClass().isArray();
            }
        });
    }

    @Override
    public boolean canAdapt(Object o) {
        return true;
    }

    @Override
    public PyObject adapt(Object o) {
        PyObject result2 = super.adapt(o);
        if (result2 != null) {
            return result2;
        }
        return PyJavaType.wrapJavaObject(o);
    }

    private static class NumberToPyFloat
    extends ClassAdapter {
        public NumberToPyFloat(Class c) {
            super(c);
        }

        @Override
        public PyObject adapt(Object o) {
            return new PyFloat(((Number)o).doubleValue());
        }
    }

    private static class NumberToPyInteger
    extends ClassAdapter {
        public NumberToPyInteger(Class c) {
            super(c);
        }

        @Override
        public PyObject adapt(Object o) {
            return new PyInteger(((Number)o).intValue());
        }
    }
}

