/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.buffer;

import org.python27.core.buffer.BaseBuffer;

public abstract class Base1DBuffer
extends BaseBuffer {
    protected static final int[] ONE = new int[]{1};
    protected static final int[] ZERO = new int[]{0};

    protected Base1DBuffer(int featureFlags, int index0, int size, int[] strides) {
        int[] nArray;
        if (size == 0) {
            nArray = ZERO;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = size;
        }
        super(featureFlags, index0, nArray, strides);
    }

    protected Base1DBuffer(int featureFlags, int index0, int size, int stride) {
        int[] nArray;
        if (stride == 1) {
            nArray = ONE;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = stride;
        }
        this(featureFlags, index0, size, nArray);
    }

    @Override
    protected int getSize() {
        return this.shape[0];
    }

    @Override
    public int getLen() {
        return this.shape[0] * this.getItemsize();
    }

    @Override
    protected int calcGreatestIndex() {
        int stride = this.strides[0];
        if (stride == 1) {
            return this.index0 + this.shape[0] - 1;
        }
        if (stride > 0) {
            return this.index0 + (this.shape[0] - 1) * stride;
        }
        return this.index0;
    }

    @Override
    protected int calcLeastIndex() {
        int stride = this.strides[0];
        if (stride < 0) {
            return this.index0 + (this.shape[0] - 1) * stride;
        }
        return this.index0;
    }

    @Override
    public boolean isContiguous(char order) {
        if ("CFA".indexOf(order) < 0) {
            return false;
        }
        if (this.getShape()[0] < 2) {
            return true;
        }
        return this.getStrides()[0] == this.getItemsize();
    }
}

