/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.buffer;

import java.nio.ByteBuffer;
import org.python27.core.BufferProtocol;
import org.python27.core.Py;
import org.python27.core.PyBuffer;
import org.python27.core.PyException;

public abstract class BaseBuffer
implements PyBuffer {
    protected BufferProtocol obj;
    protected int[] shape;
    protected int[] strides;
    protected int index0;
    protected int exports = 1;
    private int gFeatureFlags = -281;

    protected BaseBuffer(int featureFlags, int index0, int[] shape, int[] strides) {
        this.setFeatureFlags(featureFlags | 4);
        this.index0 = index0;
        this.shape = shape;
        this.strides = strides;
    }

    protected final int getFeatureFlags() {
        return 0x118 ^ ~this.gFeatureFlags;
    }

    protected final void setFeatureFlags(int flags) {
        this.gFeatureFlags = 0xFFFFFEE7 ^ flags;
    }

    protected final void addFeatureFlags(int flags) {
        this.setFeatureFlags(flags | this.getFeatureFlags());
    }

    protected final void removeFeatureFlags(int flags) {
        this.setFeatureFlags(~flags & this.getFeatureFlags());
    }

    protected void checkRequestFlags(int flags) throws PyException {
        int syndrome = this.gFeatureFlags & (flags ^ 0x118);
        if (syndrome != 0) {
            throw BaseBuffer.bufferErrorFromSyndrome(syndrome);
        }
    }

    @Override
    public boolean isReadonly() {
        return (this.gFeatureFlags & 1) != 0;
    }

    @Override
    public int getNdim() {
        return this.shape.length;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    protected int getSize() {
        int N = this.shape.length;
        int size = this.shape[0];
        for (int k = 1; k < N; ++k) {
            size *= this.shape[k];
        }
        return size;
    }

    @Override
    public int getLen() {
        int N = this.shape.length;
        int len = this.getItemsize();
        for (int k = 0; k < N; ++k) {
            len *= this.shape[k];
        }
        return len;
    }

    @Override
    public final BufferProtocol getObj() {
        return this.obj;
    }

    protected abstract byte byteAtImpl(int var1) throws IndexOutOfBoundsException;

    protected abstract void storeAtImpl(byte var1, int var2) throws IndexOutOfBoundsException, PyException;

    @Override
    public byte byteAt(int index) throws IndexOutOfBoundsException {
        return this.byteAtImpl(this.byteIndex(index));
    }

    @Override
    public int intAt(int index) throws IndexOutOfBoundsException {
        return 0xFF & this.byteAtImpl(this.byteIndex(index));
    }

    @Override
    public void storeAt(byte value, int index) throws IndexOutOfBoundsException, PyException {
        this.storeAtImpl(value, this.byteIndex(index));
    }

    @Override
    public byte byteAt(int ... indices) throws IndexOutOfBoundsException {
        return this.byteAtImpl(this.byteIndex(indices));
    }

    @Override
    public int intAt(int ... indices) throws IndexOutOfBoundsException {
        return 0xFF & this.byteAt(indices);
    }

    @Override
    public void storeAt(byte value, int ... indices) throws IndexOutOfBoundsException, PyException {
        this.storeAtImpl(value, this.byteIndex(indices));
    }

    @Override
    public int byteIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.shape[0]) {
            throw new IndexOutOfBoundsException();
        }
        return this.index0 + index * this.strides[0];
    }

    @Override
    public int byteIndex(int ... indices) throws IndexOutOfBoundsException {
        int N = this.checkDimension(indices);
        int index = this.index0;
        for (int k = 0; k < N; ++k) {
            int ik = indices[k];
            if (ik < 0 || ik >= this.shape[k]) {
                throw new IndexOutOfBoundsException();
            }
            index += ik * this.strides[k];
        }
        return index;
    }

    protected int calcGreatestIndex() {
        int N = this.shape.length;
        int index = this.index0;
        int[] strides = this.getStrides();
        for (int k = 0; k < N; ++k) {
            int stride = strides[k];
            if (stride <= 0) continue;
            index += (this.shape[k] - 1) * stride;
        }
        return index;
    }

    protected int calcLeastIndex() {
        int N = this.shape.length;
        int index = this.index0;
        int[] strides = this.getStrides();
        for (int k = 0; k < N; ++k) {
            int stride = strides[k];
            if (stride >= 0) continue;
            index += (this.shape[k] - 1) * stride;
        }
        return index;
    }

    @Override
    public void copyTo(byte[] dest, int destPos) throws IndexOutOfBoundsException {
        this.copyTo(0, dest, destPos, this.getSize());
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int count2) throws IndexOutOfBoundsException, PyException {
        this.checkDimension(1);
        int itemsize = this.getItemsize();
        int s = srcIndex;
        int d = destPos;
        if (itemsize == 1) {
            for (int i = 0; i < count2; ++i) {
                dest[d++] = this.byteAt(s++);
            }
        } else {
            for (int i = 0; i < count2; ++i) {
                int p = this.byteIndex(s++);
                for (int j = 0; j < itemsize; ++j) {
                    dest[d++] = this.byteAtImpl(p + j);
                }
            }
        }
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int count2) throws IndexOutOfBoundsException, PyException {
        this.checkDimension(1);
        this.checkWritable();
        int itemsize = this.getItemsize();
        int d = destIndex;
        int s = srcPos;
        if (itemsize == 1) {
            for (int i = 0; i < count2; ++i) {
                this.storeAt(src[s++], d++);
            }
        } else {
            for (int i = 0; i < count2; ++i) {
                int p = this.byteIndex(d++);
                for (int j = 0; j < itemsize; ++j) {
                    this.storeAtImpl(src[s++], p++);
                }
            }
        }
    }

    @Override
    public void copyFrom(PyBuffer src) throws IndexOutOfBoundsException, PyException {
        this.checkDimension(1);
        this.checkWritable();
        int itemsize = this.getItemsize();
        int count2 = this.getSize();
        int byteLen = src.getLen();
        if (src.getItemsize() != itemsize || byteLen != count2 * itemsize) {
            throw BaseBuffer.differentStructure();
        }
        byte[] t = new byte[byteLen];
        src.copyTo(t, 0);
        this.copyFrom(t, 0, 0, count2);
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        if (this.exports > 0) {
            return this.getBufferAgain(flags);
        }
        throw BaseBuffer.bufferReleased("getBuffer");
    }

    public synchronized BaseBuffer getBufferAgain(int flags) {
        this.checkRequestFlags(flags);
        ++this.exports;
        return this;
    }

    @Override
    public void release() {
        if (--this.exports == 0) {
            this.releaseAction();
            PyBuffer root = this.getRoot();
            if (root != this) {
                root.release();
            }
        } else if (this.exports < 0) {
            this.exports = 0;
            throw BaseBuffer.bufferReleased("release");
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public boolean isReleased() {
        return this.exports <= 0;
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2) {
        return this.getBufferSlice(flags, start, count2, 1);
    }

    protected abstract ByteBuffer getNIOByteBufferImpl();

    @Override
    public ByteBuffer getNIOByteBuffer() {
        ByteBuffer b = this.getNIOByteBufferImpl();
        if (this.shape.length == 1 && this.isContiguous('A')) {
            int stride = this.strides[0];
            if (this.getItemsize() == stride) {
                b.limit(this.index0 + this.shape[0] * stride);
            }
        }
        b.position(this.index0);
        return b;
    }

    @Override
    public boolean hasArray() {
        return (this.gFeatureFlags & 0x10000000) == 0;
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        this.checkHasArray();
        return new PyBuffer.Pointer(this.getNIOByteBuffer().array(), this.index0);
    }

    @Override
    public PyBuffer.Pointer getPointer(int index) throws IndexOutOfBoundsException {
        PyBuffer.Pointer p = this.getBuf();
        p.offset = this.byteIndex(index);
        return p;
    }

    @Override
    public PyBuffer.Pointer getPointer(int ... indices) throws IndexOutOfBoundsException {
        PyBuffer.Pointer p = this.getBuf();
        p.offset = this.byteIndex(indices);
        return p;
    }

    @Override
    public int[] getStrides() {
        return this.strides;
    }

    @Override
    public int[] getSuboffsets() {
        return null;
    }

    private boolean isCContiguous() {
        int N = this.shape.length;
        int size = this.getItemsize();
        for (int k = N - 1; k >= 0; --k) {
            int nk = this.shape[k];
            if (nk <= 1) continue;
            if (this.strides[k] != size) {
                return false;
            }
            size *= nk;
        }
        return true;
    }

    private boolean isFortranContiguous() {
        int N = this.shape.length;
        int size = this.getItemsize();
        for (int k = 0; k < N; ++k) {
            int nk = this.shape[k];
            if (nk <= 1) continue;
            if (this.strides[k] != size) {
                return false;
            }
            size *= nk;
        }
        return true;
    }

    @Override
    public boolean isContiguous(char order) {
        if (this.getSuboffsets() != null) {
            return false;
        }
        switch (order) {
            case 'C': {
                return this.isCContiguous();
            }
            case 'F': {
                return this.isFortranContiguous();
            }
            case 'A': {
                return this.isCContiguous() || this.isFortranContiguous();
            }
        }
        return false;
    }

    @Override
    public String getFormat() {
        return "B";
    }

    @Override
    public int getItemsize() {
        return 1;
    }

    protected void releaseAction() {
    }

    protected PyBuffer getRoot() {
        return this;
    }

    @Override
    public String toString() {
        int n = this.getLen();
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            sb.appendCodePoint(this.intAt(i));
        }
        return sb.toString();
    }

    int checkDimension(int[] indices) throws PyException {
        int n = indices.length;
        this.checkDimension(n);
        return n;
    }

    void checkDimension(int n) throws PyException {
        int ndim = this.getNdim();
        if (n != ndim) {
            String fmt = "buffer with %d dimension%s accessed as having %d dimension%s";
            String msg2 = String.format(fmt, ndim, ndim == 1 ? "" : "s", n, n, n == 1 ? "" : "s");
            throw Py.BufferError(msg2);
        }
    }

    protected void checkWritable() throws PyException {
        if (this.isReadonly()) {
            throw BaseBuffer.notWritable();
        }
    }

    protected void checkHasArray() throws PyException {
        if (!this.hasArray()) {
            throw BaseBuffer.bufferIsNot("accessible as a Java array");
        }
    }

    private static PyException bufferErrorFromSyndrome(int syndrome) {
        if ((syndrome & 8) != 0) {
            return BaseBuffer.bufferRequires("shape array");
        }
        if ((syndrome & 1) != 0) {
            return BaseBuffer.bufferIsNot("writable");
        }
        if ((syndrome & 0x10000000) != 0) {
            return BaseBuffer.bufferIsNot("accessible as a Java array");
        }
        if ((syndrome & 0x38) != 0) {
            return BaseBuffer.bufferIsNot("C-contiguous");
        }
        if ((syndrome & 0x58) != 0) {
            return BaseBuffer.bufferIsNot("Fortran-contiguous");
        }
        if ((syndrome & 0x98) != 0) {
            return BaseBuffer.bufferIsNot("contiguous");
        }
        if ((syndrome & 0x18) != 0) {
            return BaseBuffer.bufferRequires("strides array");
        }
        if ((syndrome & 0x118) != 0) {
            return BaseBuffer.bufferRequires("suboffsets array");
        }
        return BaseBuffer.bufferIsNot("capable of matching request");
    }

    protected static PyException notWritable() {
        return Py.TypeError("cannot modify read-only memory");
    }

    protected static PyException bufferIsNot(String property) {
        return Py.BufferError("underlying buffer is not " + property);
    }

    protected static PyException differentStructure() {
        return Py.ValueError("buffer assignment: lvalue and rvalue have different structures");
    }

    protected static PyException bufferRequires(String feature) {
        return Py.BufferError("buffer structure requires consumer to use " + feature);
    }

    protected static PyException bufferReleased(String operation) {
        String op = operation == null ? "" : operation + " ";
        return Py.BufferError(op + "operation forbidden on released buffer object");
    }
}

