/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.buffer;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.python27.core.PyBuffer;
import org.python27.core.PyException;
import org.python27.core.buffer.Base1DBuffer;

public abstract class BaseNIOBuffer
extends Base1DBuffer {
    protected ByteBuffer storage;

    protected BaseNIOBuffer(ByteBuffer storage, int featureFlags, int index0, int size, int stride) {
        super(featureFlags & 0xEFFFFFFE, index0, size, stride);
        this.storage = storage;
        if (!storage.isReadOnly()) {
            this.addFeatureFlags(1);
        }
        if (storage.hasArray()) {
            this.addFeatureFlags(0x10000000);
        }
    }

    @Override
    protected byte byteAtImpl(int byteIndex) throws IndexOutOfBoundsException {
        return this.storage.get(byteIndex);
    }

    @Override
    protected void storeAtImpl(byte value, int byteIndex) throws PyException {
        try {
            this.storage.put(byteIndex, value);
        }
        catch (ReadOnlyBufferException rbe) {
            throw BaseNIOBuffer.notWritable();
        }
    }

    @Override
    public int byteIndex(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices.length);
        return this.byteIndex(indices[0]);
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int count2) throws IndexOutOfBoundsException {
        ByteBuffer destBuf = ByteBuffer.wrap(dest, destPos, count2 * this.getItemsize());
        this.copyTo(srcIndex, destBuf, count2);
    }

    public void copyTo(ByteBuffer dest) throws BufferOverflowException, ReadOnlyBufferException {
        this.copyTo(0, dest, this.shape[0]);
    }

    protected void copyTo(int srcIndex, ByteBuffer dest, int count2) throws BufferOverflowException, ReadOnlyBufferException, IndexOutOfBoundsException {
        block6: {
            if (count2 <= 0) break block6;
            ByteBuffer src = this.getNIOByteBuffer();
            int pos = this.byteIndex(srcIndex);
            int itemsize = this.getItemsize();
            int stride = this.getStrides()[0];
            if (stride == itemsize) {
                src.limit(pos + count2 * itemsize).position(pos);
                dest.put(src);
            } else if (itemsize == 1) {
                for (int i = 0; i < count2; ++i) {
                    src.position(pos);
                    dest.put(src.get());
                    pos += stride;
                }
            } else {
                for (int i = 0; i < count2; ++i) {
                    src.limit(pos + itemsize).position(pos);
                    dest.put(src);
                    pos += stride;
                }
            }
        }
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int count2) throws IndexOutOfBoundsException, PyException {
        ByteBuffer srcBuf = ByteBuffer.wrap(src, srcPos, count2 * this.getItemsize());
        this.copyFrom(srcBuf, destIndex, count2);
    }

    protected void copyFrom(ByteBuffer src, int destIndex, int count2) throws IndexOutOfBoundsException, PyException {
        block7: {
            this.checkWritable();
            if (count2 <= 0) break block7;
            ByteBuffer dest = this.getNIOByteBuffer();
            int pos = this.byteIndex(destIndex);
            int itemsize = this.getItemsize();
            int stride = this.getStrides()[0];
            int skip = stride - itemsize;
            int size = this.getSize();
            if ((destIndex | count2 | size - (destIndex + count2)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (skip == 0) {
                dest.position(pos);
                dest.put(src);
            } else if (itemsize == 1) {
                for (int i = 0; i < count2; ++i) {
                    dest.position(pos);
                    dest.put(src.get());
                    pos += stride;
                }
            } else {
                for (int i = 0; i < count2; ++i) {
                    dest.position(pos);
                    src.limit(src.position() + itemsize);
                    dest.put(src);
                    pos += stride;
                }
            }
        }
    }

    @Override
    protected ByteBuffer getNIOByteBufferImpl() {
        return this.storage.duplicate();
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        this.checkHasArray();
        return new PyBuffer.Pointer(this.storage.array(), this.index0);
    }
}

