/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.buffer;

import java.nio.ByteBuffer;
import org.python27.core.BufferProtocol;
import org.python27.core.PyBuffer;
import org.python27.core.PyException;
import org.python27.core.buffer.BaseNIOBuffer;
import org.python27.core.buffer.Strided1DNIOBuffer;
import org.python27.core.buffer.ZeroByteBuffer;

public class SimpleNIOBuffer
extends BaseNIOBuffer {
    protected SimpleNIOBuffer(BufferProtocol obj, ByteBuffer storage, int index0, int size) throws PyException, ArrayIndexOutOfBoundsException {
        super(storage, 224, index0, size, 1);
        this.obj = obj;
        if ((index0 | size | storage.capacity() - (index0 + size)) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public SimpleNIOBuffer(int flags, BufferProtocol obj, ByteBuffer storage, int index0, int size) throws PyException, ArrayIndexOutOfBoundsException, NullPointerException {
        this(obj, storage.duplicate(), index0, size);
        this.checkRequestFlags(flags);
    }

    protected SimpleNIOBuffer(BufferProtocol obj, ByteBuffer storage) throws NullPointerException {
        this(obj, storage, 0, storage.capacity());
    }

    public SimpleNIOBuffer(int flags, BufferProtocol obj, ByteBuffer storage) throws PyException, NullPointerException {
        this(obj, storage.duplicate());
        this.checkRequestFlags(flags);
    }

    @Override
    public int getLen() {
        return this.shape[0];
    }

    @Override
    public final int byteIndex(int index) throws IndexOutOfBoundsException {
        return this.index0 + index;
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2) {
        if (count2 > 0) {
            int compIndex0 = this.index0 + start;
            return new SimpleView(this.getRoot(), flags, this.storage, compIndex0, count2);
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2, int stride) {
        if (stride == 1 || count2 < 2) {
            return this.getBufferSlice(flags, start, count2);
        }
        int compIndex0 = this.index0 + start;
        return new Strided1DNIOBuffer.SlicedView(this.getRoot(), flags, this.storage, compIndex0, count2, stride);
    }

    static class SimpleView
    extends SimpleNIOBuffer {
        PyBuffer root;

        public SimpleView(PyBuffer root, int flags, ByteBuffer storage, int offset, int count2) {
            super(flags, root.getObj(), storage, offset, count2);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }
    }
}

