/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.buffer;

import java.nio.ByteBuffer;
import org.python27.core.BufferProtocol;
import org.python27.core.PyBuffer;
import org.python27.core.buffer.SimpleBuffer;
import org.python27.core.buffer.ZeroByteBuffer;
import org.python27.core.util.StringUtil;

public class SimpleStringBuffer
extends SimpleBuffer {
    private String bufString;

    public SimpleStringBuffer(int flags, BufferProtocol obj, String bufString) {
        super(obj, null, 0, bufString.length());
        this.bufString = bufString;
        this.checkRequestFlags(flags);
    }

    @Override
    public int getLen() {
        return this.bufString.length();
    }

    @Override
    public final byte byteAtImpl(int index) {
        return (byte)this.bufString.charAt(index);
    }

    @Override
    public final int byteIndex(int index) {
        return index;
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int count2) throws IndexOutOfBoundsException {
        int endIndex = srcIndex + count2;
        int p = destPos;
        for (int i = srcIndex; i < endIndex; ++i) {
            dest[p++] = (byte)this.bufString.charAt(i);
        }
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2) {
        if (count2 > 0) {
            return new SimpleStringView(this.getRoot(), flags, this.bufString.substring(start, start + count2));
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2, int stride) {
        if (stride == 1) {
            return this.getBufferSlice(flags, start, count2);
        }
        this.ensureHaveBytes();
        return super.getBufferSlice(flags, start, count2, stride);
    }

    @Override
    protected ByteBuffer getNIOByteBufferImpl() {
        this.ensureHaveBytes();
        ByteBuffer b = ByteBuffer.wrap(this.storage);
        return b.asReadOnlyBuffer();
    }

    private void ensureHaveBytes() {
        if (this.storage == null) {
            this.storage = StringUtil.toBytes(this.bufString);
        }
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        this.ensureHaveBytes();
        return super.getBuf();
    }

    @Override
    public PyBuffer.Pointer getPointer(int index) {
        this.ensureHaveBytes();
        return super.getPointer(index);
    }

    @Override
    public PyBuffer.Pointer getPointer(int ... indices) {
        this.ensureHaveBytes();
        return super.getPointer(indices);
    }

    @Override
    public String toString() {
        return this.bufString;
    }

    static class SimpleStringView
    extends SimpleStringBuffer {
        PyBuffer root;

        public SimpleStringView(PyBuffer root, int flags, String bufString) {
            super(flags, root.getObj(), bufString);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }
    }
}

