/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.buffer;

import org.python27.core.BufferProtocol;
import org.python27.core.PyBuffer;
import org.python27.core.PyException;
import org.python27.core.buffer.BaseArrayBuffer;
import org.python27.core.buffer.ZeroByteBuffer;

public class Strided1DBuffer
extends BaseArrayBuffer {
    protected int stride;

    protected Strided1DBuffer(BufferProtocol obj, byte[] storage, int index0, int count2, int stride) throws ArrayIndexOutOfBoundsException, NullPointerException {
        super(storage, 24, index0, count2, stride);
        this.obj = obj;
        this.stride = stride;
        if (count2 == 0) {
            this.addFeatureFlags(224);
        } else {
            int hi;
            int lo;
            if (stride == 1) {
                lo = index0;
                hi = index0 + count2;
                this.addFeatureFlags(224);
            } else if (stride > 1) {
                lo = index0;
                hi = index0 + (count2 - 1) * stride + 1;
            } else {
                hi = index0 + 1;
                lo = index0 + (count2 - 1) * stride;
            }
            if ((count2 | lo | storage.length - lo | hi | storage.length - hi) < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public Strided1DBuffer(int flags, BufferProtocol obj, byte[] storage, int index0, int count2, int stride) throws ArrayIndexOutOfBoundsException, NullPointerException, PyException {
        this(obj, storage, index0, count2, stride);
        this.checkRequestFlags(flags);
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    @Override
    public final int byteIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.shape[0]) {
            throw new IndexOutOfBoundsException();
        }
        return this.index0 + index * this.stride;
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2, int stride) {
        if (count2 > 0) {
            int compStride = this.stride * stride;
            int compIndex0 = this.index0 + start * this.stride;
            return new SlicedView(this.getRoot(), flags, this.storage, compIndex0, count2, compStride);
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer.Pointer getPointer(int index) {
        return new PyBuffer.Pointer(this.storage, this.index0 + index * this.stride);
    }

    @Override
    public PyBuffer.Pointer getPointer(int ... indices) {
        this.checkDimension(indices.length);
        return this.getPointer(indices[0]);
    }

    static class SlicedView
    extends Strided1DBuffer {
        PyBuffer root;

        public SlicedView(PyBuffer root, int flags, byte[] storage, int index0, int count2, int stride) throws PyException {
            super(flags, root.getObj(), storage, index0, count2, stride);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }
    }
}

