/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.buffer;

import org.python27.core.BufferProtocol;
import org.python27.core.PyBuffer;
import org.python27.core.PyException;
import org.python27.core.buffer.BaseArrayBuffer;

public class ZeroByteBuffer
extends BaseArrayBuffer {
    private static final byte[] EMPTY = new byte[0];

    public ZeroByteBuffer(int flags, BufferProtocol obj, boolean readonly, boolean hasArray) throws PyException {
        super(EMPTY, 0xE0 | (readonly ? 0 : 1), 0, 0, 1);
        this.obj = obj;
        if (!hasArray) {
            this.removeFeatureFlags(0x10000000);
        }
        this.checkRequestFlags(flags);
    }

    @Override
    public int getLen() {
        return 0;
    }

    @Override
    public int byteIndex(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int byteIndex(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices);
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void copyTo(byte[] dest, int destPos) throws IndexOutOfBoundsException {
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int count2) throws IndexOutOfBoundsException, PyException {
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int count2) throws IndexOutOfBoundsException, PyException {
        if (this.isReadonly()) {
            throw ZeroByteBuffer.notWritable();
        }
        if (count2 > 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void copyFrom(PyBuffer src) throws IndexOutOfBoundsException, PyException {
        if (this.isReadonly()) {
            throw ZeroByteBuffer.notWritable();
        }
        if (src.getLen() > 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2) {
        if (start == 0 && count2 <= 0) {
            return this.getBuffer(flags);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2, int stride) {
        return this.getBufferSlice(flags, start, count2);
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        return new PyBuffer.Pointer(EMPTY, 0);
    }

    @Override
    public String toString() {
        return "";
    }

    static class View
    extends ZeroByteBuffer {
        PyBuffer root;

        public View(PyBuffer root, int flags) {
            super(flags, root.getObj(), root.isReadonly(), root.hasArray());
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }
    }
}

