/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.finalization;

import org.python27.core.JyAttribute;
import org.python27.core.PyObject;
import org.python27.core.finalization.FinalizableBuiltin;
import org.python27.core.finalization.FinalizablePyObject;
import org.python27.core.finalization.FinalizablePyObjectDerived;
import org.python27.core.finalization.FinalizeTriggerFactory;
import org.python27.modules.gc;

public class FinalizeTrigger {
    public static final byte NOTIFY_GC_FLAG = 1;
    public static final byte NOT_FINALIZABLE_FLAG = 8;
    public static final byte ONLY_BUILTIN_FLAG = 16;
    public static final byte FINALIZED_FLAG = 32;
    public static FinalizeTriggerFactory factory;
    protected PyObject toFinalize;
    public byte flags = 0;

    public static FinalizeTrigger makeTrigger(PyObject toFinalize) {
        if (factory != null) {
            return factory.makeTrigger(toFinalize);
        }
        return new FinalizeTrigger(toFinalize);
    }

    public static boolean hasActiveTrigger(PyObject obj) {
        Object fn = JyAttribute.getAttr(obj, (byte)127);
        return fn != null && ((FinalizeTrigger)fn).isActive();
    }

    public static boolean isFinalizable(PyObject obj) {
        return obj instanceof FinalizablePyObject || obj instanceof FinalizableBuiltin || obj instanceof FinalizablePyObjectDerived;
    }

    public static void ensureFinalizer(PyObject resurrect) {
        JyAttribute.setAttr(resurrect, (byte)127, FinalizeTrigger.makeTrigger(resurrect));
    }

    public static void runFinalizer(PyObject toFinalize) {
        FinalizeTrigger.runFinalizer(toFinalize, false);
    }

    public static void runFinalizer(PyObject toFinalize, boolean runBuiltinOnly) {
        if (!runBuiltinOnly) {
            if (toFinalize instanceof FinalizablePyObjectDerived) {
                try {
                    ((FinalizablePyObjectDerived)((Object)toFinalize)).__del_derived__();
                }
                catch (Exception exception) {}
            } else if (toFinalize instanceof FinalizablePyObject) {
                try {
                    ((FinalizablePyObject)((Object)toFinalize)).__del__();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (toFinalize instanceof FinalizableBuiltin) {
            try {
                ((FinalizableBuiltin)((Object)toFinalize)).__del_builtin__();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void appendFinalizeTriggerForBuiltin(PyObject obj) {
        if (obj instanceof FinalizableBuiltin) {
            FinalizeTrigger ft = FinalizeTrigger.makeTrigger(obj);
            ft.flags = (byte)16;
            JyAttribute.setAttr(obj, (byte)127, ft);
        } else {
            JyAttribute.delAttr(obj, (byte)127);
        }
    }

    public void clear() {
        this.toFinalize = null;
    }

    public void trigger(PyObject toFinalize) {
        this.toFinalize = toFinalize;
    }

    public boolean isActive() {
        return this.toFinalize != null;
    }

    protected FinalizeTrigger(PyObject toFinalize) {
        this.toFinalize = toFinalize;
    }

    protected boolean isCyclic() {
        gc.CycleMarkAttr cm = (gc.CycleMarkAttr)JyAttribute.getAttr(this.toFinalize, (byte)5);
        if (cm != null && cm.isCyclic()) {
            return true;
        }
        gc.markCyclicObjects(this.toFinalize, (this.flags & 8) == 0);
        cm = (gc.CycleMarkAttr)JyAttribute.getAttr(this.toFinalize, (byte)5);
        return cm != null && cm.isCyclic();
    }

    protected boolean isUncollectable() {
        gc.CycleMarkAttr cm = (gc.CycleMarkAttr)JyAttribute.getAttr(this.toFinalize, (byte)5);
        if (cm != null && cm.isUncollectable()) {
            return true;
        }
        gc.markCyclicObjects(this.toFinalize, (this.flags & 8) == 0);
        cm = (gc.CycleMarkAttr)JyAttribute.getAttr(this.toFinalize, (byte)5);
        return cm != null && cm.isUncollectable();
    }

    public void performFinalization() {
        if (this.toFinalize != null) {
            int saveGarbage = 0;
            if ((gc.getJythonGCFlags() & 2) != 0) {
                if (this.isUncollectable()) {
                    saveGarbage = 1;
                } else if (!this.isCyclic()) {
                    saveGarbage = -1;
                    FinalizeTrigger.runFinalizer(this.toFinalize, (this.flags & 0x10) != 0);
                }
            } else if ((this.flags & 8) == 0) {
                FinalizeTrigger.runFinalizer(this.toFinalize, (this.flags & 0x10) != 0);
            }
            if ((gc.getJythonGCFlags() & 0x2000) != 0) {
                gc.writeDebug("gc", "finalization of " + this.toFinalize);
            }
            if (saveGarbage == 1 || saveGarbage == 0 && (gc.get_debug() & 0x20) != 0 && this.isCyclic()) {
                if ((this.flags & 8) == 0) {
                    FinalizeTrigger.appendFinalizeTriggerForBuiltin(this.toFinalize);
                }
                gc.garbage.add(this.toFinalize);
                if ((gc.getJythonGCFlags() & 0x2000) != 0) {
                    gc.writeDebug("gc", this.toFinalize + " added to garbage.");
                }
            }
        }
        if ((this.flags & 1) != 0) {
            if ((gc.getJythonGCFlags() & 0x2000) != 0) {
                gc.writeDebug("gc", "notify finalization of " + this.toFinalize);
            }
            gc.notifyFinalize(this.toFinalize);
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }
    }

    protected void finalize() throws Throwable {
        this.flags = (byte)(this.flags | 0x20);
        gc.notifyPreFinalization();
        if (gc.delayedFinalizationEnabled() && this.toFinalize != null) {
            if ((gc.getJythonGCFlags() & 0x2000) != 0) {
                gc.writeDebug("gc", "delayed finalization for " + this.toFinalize);
            }
            gc.registerForDelayedFinalization(this.toFinalize);
        } else {
            this.performFinalization();
        }
        gc.notifyPostFinalization();
    }

    public boolean isFinalized() {
        return (this.flags & 0x20) != 0;
    }
}

