/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.python27.core.Py;
import org.python27.core.io.SocketIOBase;

public class DatagramSocketIO
extends SocketIOBase<DatagramChannel> {
    public DatagramSocketIO(DatagramChannel socketChannel, String mode) {
        super(socketChannel, mode);
    }

    @Override
    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            return ((DatagramChannel)this.socketChannel).read(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long readinto(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkReadable();
        try {
            return ((DatagramChannel)this.socketChannel).read(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return ((DatagramChannel)this.socketChannel).write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long write(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkWritable();
        try {
            return ((DatagramChannel)this.socketChannel).write(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }
}

