/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import jnr.constants.Constant;
import jnr.constants.platform.Errno;
import jnr.posix.util.FieldAccess;
import org.python27.core.Py;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.core.io.RawIOBase;
import org.python27.core.util.RelativeFile;
import org.python27.modules.posix.PosixModule;

public class FileIO
extends RawIOBase {
    private FileChannel fileChannel;
    private RandomAccessFile file;
    private FileOutputStream fileOutputStream;
    private boolean reading;
    private boolean writing;
    private boolean appending;
    private boolean plus;
    private boolean emulateAppend;

    public FileIO(String name, String mode) {
        this(Py.newUnicode(name), mode);
    }

    public FileIO(PyString name, String mode) {
        this.parseMode(mode);
        RelativeFile absPath = new RelativeFile(Py.fileSystemDecode(name));
        try {
            if (this.appending && !this.reading && !this.plus || this.writing && !this.reading && !this.plus) {
                this.fromFileOutputStream(absPath);
            } else {
                this.fromRandomAccessFile(absPath);
                this.emulateAppend = this.appending;
            }
        }
        catch (FileNotFoundException fnfe) {
            if (absPath.isDirectory()) {
                throw Py.IOError((Constant)Errno.EISDIR, name);
            }
            if (this.writing && !absPath.canWrite() || fnfe.getMessage().endsWith("(Permission denied)")) {
                throw Py.IOError((Constant)Errno.EACCES, name);
            }
            throw Py.IOError((Constant)Errno.ENOENT, name);
        }
        this.initPosition();
    }

    public FileIO(FileChannel fileChannel, String mode) {
        this.parseMode(mode);
        this.fileChannel = fileChannel;
        this.initPosition();
    }

    private void parseMode(String mode) {
        boolean rwa = false;
        block6: for (int i = 0; i < mode.length(); ++i) {
            switch (mode.charAt(i)) {
                case 'r': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.reading = true;
                    continue block6;
                }
                case 'w': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writing = true;
                    continue block6;
                }
                case 'a': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writing = true;
                    this.appending = true;
                    continue block6;
                }
                case '+': {
                    if (this.plus || !rwa) {
                        this.badMode();
                    }
                    this.plus = true;
                    this.writing = true;
                    continue block6;
                }
                default: {
                    throw Py.ValueError("invalid mode: '" + mode + "'");
                }
            }
        }
        if (!rwa) {
            this.badMode();
        }
    }

    private void fromRandomAccessFile(File absPath) throws FileNotFoundException {
        String rafMode = "r" + (this.writing ? "w" : "");
        if (this.plus && this.reading && !absPath.isFile()) {
            this.writing = false;
            throw new FileNotFoundException("");
        }
        this.file = new RandomAccessFile(absPath, rafMode);
        this.fileChannel = this.file.getChannel();
    }

    private void fromFileOutputStream(File absPath) throws FileNotFoundException {
        this.fileOutputStream = new FileOutputStream(absPath, this.appending);
        this.fileChannel = this.fileOutputStream.getChannel();
    }

    private void badMode() {
        throw Py.ValueError("Must have exactly one of read/write/append mode");
    }

    private void initPosition() {
        if (this.appending) {
            this.seek(0L, 2);
        } else if (this.writing && !this.reading) {
            try {
                this.fileChannel.truncate(0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isatty() {
        this.checkClosed();
        if (this.file == null || this.fileOutputStream == null) {
            return false;
        }
        try {
            return PosixModule.getPOSIX().isatty(this.file != null ? this.file.getFD() : this.fileOutputStream.getFD());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            int n = this.fileChannel.read(buf);
            return n > 0 ? n : 0;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long readinto(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkReadable();
        try {
            long n = this.fileChannel.read(bufs);
            return n > 0L ? n : 0L;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public ByteBuffer readall() {
        long toRead;
        this.checkClosed();
        this.checkReadable();
        try {
            toRead = Math.max(0L, this.fileChannel.size() - this.fileChannel.position());
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        if (toRead > Integer.MAX_VALUE) {
            throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
        }
        if (toRead == 0L) {
            return this.readallInChunks();
        }
        ByteBuffer all = ByteBuffer.allocate((int)toRead);
        this.readinto(all);
        all.flip();
        return all;
    }

    private ByteBuffer readallInChunks() {
        int chunkSize;
        ArrayList<ByteBuffer> chunks = new ArrayList<ByteBuffer>();
        int MAX_CHUNK_SIZE = 8192;
        int length = 0;
        do {
            ByteBuffer chunk2 = ByteBuffer.allocate(8192);
            this.readinto(chunk2);
            chunkSize = chunk2.position();
            length += chunkSize;
            chunk2.flip();
            chunks.add(chunk2);
        } while (chunkSize >= 8192);
        if (chunks.size() == 1) {
            return (ByteBuffer)chunks.get(0);
        }
        ByteBuffer all = ByteBuffer.allocate(length);
        for (ByteBuffer chunk3 : chunks) {
            all.put(chunk3);
        }
        all.flip();
        return all;
    }

    @Override
    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.emulateAppend ? this.appendFromByteBuffer(buf) : this.fileChannel.write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    private int appendFromByteBuffer(ByteBuffer buf) throws IOException {
        int written = this.fileChannel.write(buf, this.fileChannel.position());
        if (written > 0) {
            this.fileChannel.position(this.fileChannel.position() + (long)written);
        }
        return written;
    }

    @Override
    public long write(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkWritable();
        try {
            return !this.emulateAppend ? this.fileChannel.write(bufs) : this.writeAppend(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    private long writeAppend(ByteBuffer[] bufs) throws IOException {
        long count2 = 0L;
        for (ByteBuffer buf : bufs) {
            if (!buf.hasRemaining()) continue;
            int bufCount = this.appendFromByteBuffer(buf);
            if (bufCount == 0) break;
            count2 += (long)bufCount;
        }
        return count2;
    }

    @Override
    public long seek(long pos, int whence) {
        this.checkClosed();
        try {
            switch (whence) {
                case 0: {
                    break;
                }
                case 1: {
                    pos += this.fileChannel.position();
                    break;
                }
                case 2: {
                    pos += this.fileChannel.size();
                    break;
                }
                default: {
                    throw Py.IOError(Errno.EINVAL);
                }
            }
            this.fileChannel.position(pos);
            return pos;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long tell() {
        this.checkClosed();
        try {
            return this.fileChannel.position();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long truncate(long size) {
        this.checkClosed();
        this.checkWritable();
        try {
            long oldPosition = this.fileChannel.position();
            this.fileChannel.truncate(size);
            this.fileChannel.position(oldPosition);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        return size;
    }

    @Override
    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        super.close();
    }

    @Override
    public OutputStream asOutputStream() {
        return this.writing ? Channels.newOutputStream(this.fileChannel) : super.asOutputStream();
    }

    @Override
    public InputStream asInputStream() {
        return this.readable() ? Channels.newInputStream(this.fileChannel) : super.asInputStream();
    }

    @Override
    public boolean readable() {
        return this.reading || this.plus;
    }

    @Override
    public boolean writable() {
        return this.writing;
    }

    @Override
    public FileChannel getChannel() {
        return this.fileChannel;
    }

    public FileDescriptor getFD() {
        if (this.file != null) {
            try {
                return this.file.getFD();
            }
            catch (IOException ioe) {
                throw Py.OSError(ioe);
            }
        }
        if (this.fileOutputStream != null) {
            try {
                return this.fileOutputStream.getFD();
            }
            catch (IOException ioe) {
                throw Py.OSError(ioe);
            }
        }
        throw Py.OSError(Errno.EBADF);
    }

    public PyObject __int__() {
        int intFD = -1;
        try {
            Field fdField = FieldAccess.getProtectedField(FileDescriptor.class, "fd");
            intFD = fdField.getInt(this.getFD());
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Py.newInteger(intFD);
    }

    public PyObject __add__(PyObject otherObj) {
        return this.__int__().__add__(otherObj);
    }

    private static class os {
        public static final int SEEK_SET = 0;
        public static final int SEEK_CUR = 1;
        public static final int SEEK_END = 2;

        private os() {
        }
    }
}

