/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.io;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.python27.core.Py;
import org.python27.core.io.IOBase;

public abstract class RawIOBase
extends IOBase {
    public ByteBuffer read(int size) {
        if (size < 0) {
            return this.readall();
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.readinto(buf);
        buf.flip();
        return buf;
    }

    public ByteBuffer readall() {
        ByteBuffer all = ByteBuffer.allocate(8192);
        ByteBuffer readBuffer = ByteBuffer.allocate(8192);
        int readCount = 0;
        while ((readCount = this.readinto(readBuffer)) > 0) {
            if (all.remaining() < readCount) {
                long newSize = (long)all.position() + (long)readCount;
                if (newSize > Integer.MAX_VALUE) {
                    throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
                }
                ByteBuffer old = all;
                all = ByteBuffer.allocate(Math.max(old.capacity() * 2, (int)newSize));
                old.flip();
                all.put(old);
            }
            readBuffer.flip();
            all.put(readBuffer);
            readBuffer.clear();
        }
        all.flip();
        return all;
    }

    public int readinto(ByteBuffer buf) {
        this.unsupported("readinto");
        return -1;
    }

    public long readinto(ByteBuffer[] bufs) {
        long count2 = 0L;
        for (ByteBuffer buf : bufs) {
            if (!buf.hasRemaining()) continue;
            int bufCount = this.readinto(buf);
            if (bufCount == 0) break;
            count2 += (long)bufCount;
        }
        return count2;
    }

    public int write(ByteBuffer buf) {
        this.unsupported("write");
        return -1;
    }

    public long write(ByteBuffer[] bufs) {
        long count2 = 0L;
        for (ByteBuffer buf : bufs) {
            if (!buf.hasRemaining()) continue;
            int bufCount = this.write(buf);
            if (bufCount == 0) break;
            count2 += (long)bufCount;
        }
        return count2;
    }

    @Override
    public RawIOBase fileno() {
        this.checkClosed();
        return this;
    }

    public abstract Channel getChannel();
}

