/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.io;

import java.io.IOException;
import java.nio.channels.Channel;
import org.python27.core.Py;
import org.python27.core.io.RawIOBase;

public abstract class SocketIOBase<T extends Channel>
extends RawIOBase {
    protected T socketChannel;
    private boolean readable = false;
    private boolean writable = false;

    public SocketIOBase(T socketChannel, String mode) {
        this.socketChannel = socketChannel;
        this.parseMode(mode);
    }

    protected void parseMode(String mode) {
        if (mode.equals("r")) {
            this.readable = true;
        } else if (mode.equals("w")) {
            this.writable = true;
        } else if (mode.equals("rw")) {
            this.writable = true;
            this.readable = true;
        } else {
            throw Py.ValueError("invalid mode: '" + mode + "'");
        }
    }

    @Override
    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        super.close();
    }

    public T getChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean readable() {
        return this.readable;
    }

    @Override
    public boolean writable() {
        return this.writable;
    }
}

