/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.stringlib;

import org.python27.core.Py;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.core.PyTuple;
import org.python27.core.PyType;
import org.python27.core.PyUnicode;
import org.python27.core.Traverseproc;
import org.python27.core.Visitproc;
import org.python27.core.stringlib.FieldNameIterator$PyExposer;
import org.python27.expose.ExposedType;
import org.python27.modules.gc;

@ExposedType(name="fieldnameiterator", base=PyObject.class, isBaseType=false)
public class FieldNameIterator
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    private final String markup;
    private final boolean bytes;
    private int index;
    private Object head;

    public FieldNameIterator(String fieldName, boolean bytes) {
        this.markup = fieldName;
        this.bytes = bytes;
        this.index = this.nextDotOrBracket(fieldName);
        String headStr = fieldName.substring(0, this.index);
        try {
            this.head = Integer.parseInt(headStr);
        }
        catch (NumberFormatException e) {
            this.head = headStr;
        }
    }

    public FieldNameIterator(PyString fieldNameObject) {
        this(fieldNameObject.getString(), !(fieldNameObject instanceof PyUnicode));
    }

    @Override
    public PyObject __iter__() {
        return this.fieldnameiterator___iter__();
    }

    final PyObject fieldnameiterator___iter__() {
        return this;
    }

    @Override
    public PyObject __iternext__() {
        return this.fieldnameiterator___iternext__();
    }

    final PyObject fieldnameiterator___iternext__() {
        Chunk chunk2 = this.nextChunk();
        if (chunk2 == null) {
            return null;
        }
        return new PyTuple(Py.newBoolean(chunk2.is_attr), this.wrap(chunk2.value));
    }

    private PyObject wrap(Object value) {
        if (value instanceof Integer) {
            return Py.newInteger((Integer)value);
        }
        String s = value.toString();
        if (s.length() == 0) {
            return this.bytes ? Py.EmptyString : Py.EmptyUnicode;
        }
        return this.bytes ? Py.newString(s) : Py.newUnicode(s);
    }

    private int nextDotOrBracket(String markup) {
        int bracketPos;
        int dotPos = markup.indexOf(46, this.index);
        if (dotPos < 0) {
            dotPos = markup.length();
        }
        if ((bracketPos = markup.indexOf(91, this.index)) < 0) {
            bracketPos = markup.length();
        }
        return Math.min(dotPos, bracketPos);
    }

    public Object head() {
        return this.head;
    }

    public PyObject pyHead() {
        return this.wrap(this.head());
    }

    public final boolean isBytes() {
        return this.bytes;
    }

    public Chunk nextChunk() {
        if (this.index == this.markup.length()) {
            return null;
        }
        Chunk chunk2 = new Chunk();
        if (this.markup.charAt(this.index) == '[') {
            this.parseItemChunk(chunk2);
        } else if (this.markup.charAt(this.index) == '.') {
            this.parseAttrChunk(chunk2);
        } else {
            throw new IllegalArgumentException("Only '.' or '[' may follow ']' in format field specifier");
        }
        return chunk2;
    }

    private void parseItemChunk(Chunk chunk2) {
        chunk2.is_attr = false;
        int endBracket = this.markup.indexOf(93, this.index + 1);
        if (endBracket < 0) {
            throw new IllegalArgumentException("Missing ']' in format string");
        }
        String itemValue = this.markup.substring(this.index + 1, endBracket);
        if (itemValue.length() == 0) {
            throw new IllegalArgumentException("Empty attribute in format string");
        }
        try {
            chunk2.value = Integer.parseInt(itemValue);
        }
        catch (NumberFormatException e) {
            chunk2.value = itemValue;
        }
        this.index = endBracket + 1;
    }

    private void parseAttrChunk(Chunk chunk2) {
        ++this.index;
        chunk2.is_attr = true;
        int pos = this.nextDotOrBracket(this.markup);
        if (pos == this.index) {
            throw new IllegalArgumentException("Empty attribute in format string");
        }
        chunk2.value = this.markup.substring(this.index, pos);
        this.index = pos;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        if (this.head == null || !gc.canLinkToPyObject(this.head.getClass(), true)) {
            return 0;
        }
        return gc.traverseByReflection(this.head, visit, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
        if (ob != null && ob == this.head) {
            return true;
        }
        if (!gc.canLinkToPyObject(this.head.getClass(), true)) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    static {
        PyType.addBuilder(FieldNameIterator.class, new FieldNameIterator$PyExposer());
        TYPE = PyType.fromClass(FieldNameIterator.class);
    }

    public static class Chunk {
        public boolean is_attr;
        public Object value;
    }
}

