/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.stringlib;

import java.math.BigInteger;
import org.python27.core.Py;
import org.python27.core.PyInteger;
import org.python27.core.PyLong;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.core.stringlib.InternalFormat;

public class IntegerFormatter
extends InternalFormat.Formatter {
    private static final BigInteger LIMIT_UNICODE = BigInteger.valueOf(0x110000L);
    private static final BigInteger LIMIT_BYTE = BigInteger.valueOf(256L);
    private static final String LOOKUP = "0123456789abcdef";
    public static final InternalFormat.Spec BIN = InternalFormat.fromText("#b");
    public static final InternalFormat.Spec OCT = InternalFormat.fromText("#o");
    public static final InternalFormat.Spec HEX = InternalFormat.fromText("#x");

    public IntegerFormatter(StringBuilder result2, InternalFormat.Spec spec) {
        super(result2, spec);
    }

    public IntegerFormatter(InternalFormat.Spec spec) {
        this(new StringBuilder(34), spec);
    }

    @Override
    public IntegerFormatter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public IntegerFormatter append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    @Override
    public IntegerFormatter append(CharSequence csq, int start, int end) throws IndexOutOfBoundsException {
        super.append(csq, start, end);
        return this;
    }

    public IntegerFormatter format(BigInteger value) {
        try {
            switch (this.spec.type) {
                case 'd': 
                case 'i': 
                case 'u': 
                case '\uffff': {
                    this.format_d(value);
                    break;
                }
                case 'x': {
                    this.format_x(value, false);
                    break;
                }
                case 'X': {
                    this.format_x(value, true);
                    break;
                }
                case 'o': {
                    this.format_o(value);
                    break;
                }
                case 'b': {
                    this.format_b(value);
                    break;
                }
                case 'c': {
                    this.format_c(value);
                    break;
                }
                case 'n': {
                    this.format_d(value);
                    break;
                }
                default: {
                    throw IntegerFormatter.unknownFormat(this.spec.type, "long");
                }
            }
            if (this.spec.grouping) {
                this.groupDigits(3, ',');
            }
            return this;
        }
        catch (OutOfMemoryError eme) {
            throw IntegerFormatter.precisionTooLarge("long");
        }
    }

    void format_d(BigInteger value) {
        String number;
        if (value.signum() < 0) {
            this.negativeSign(null);
            number = value.negate().toString();
        } else {
            this.positiveSign(null);
            number = value.toString();
        }
        this.appendNumber(number);
    }

    void format_x(BigInteger value, boolean upper) {
        String number;
        String base2;
        String string2 = base2 = upper ? "0X" : "0x";
        if (value.signum() < 0) {
            this.negativeSign(base2);
            number = IntegerFormatter.toHexString(value.negate());
        } else {
            this.positiveSign(base2);
            number = IntegerFormatter.toHexString(value);
        }
        if (upper) {
            number = number.toUpperCase();
        }
        this.appendNumber(number);
    }

    void format_o(BigInteger value) {
        String number;
        String base2 = "0o";
        if (value.signum() < 0) {
            this.negativeSign(base2);
            number = IntegerFormatter.toOctalString(value.negate());
        } else {
            this.positiveSign(base2);
            number = IntegerFormatter.toOctalString(value);
        }
        this.appendNumber(number);
    }

    void format_b(BigInteger value) {
        String number;
        String base2 = "0b";
        if (value.signum() < 0) {
            this.negativeSign(base2);
            number = IntegerFormatter.toBinaryString(value.negate());
        } else {
            this.positiveSign(base2);
            number = IntegerFormatter.toBinaryString(value);
        }
        this.appendNumber(number);
    }

    void format_c(BigInteger value) {
        BigInteger limit;
        BigInteger bigInteger = limit = this.bytes ? LIMIT_BYTE : LIMIT_UNICODE;
        if (value.signum() < 0 || value.compareTo(limit) >= 0) {
            throw Py.OverflowError("%c arg not in range(0x" + IntegerFormatter.toHexString(limit) + ")");
        }
        this.result.appendCodePoint(value.intValue());
    }

    public IntegerFormatter format(int value) {
        try {
            this.setStart();
            switch (this.spec.type) {
                case 'd': 
                case 'i': 
                case 'u': 
                case '\uffff': {
                    this.format_d(value);
                    break;
                }
                case 'x': {
                    this.format_x(value, false);
                    break;
                }
                case 'X': {
                    this.format_x(value, true);
                    break;
                }
                case 'o': {
                    this.format_o(value);
                    break;
                }
                case 'b': {
                    this.format_b(value);
                    break;
                }
                case '%': 
                case 'c': {
                    this.format_c(value);
                    break;
                }
                case 'n': {
                    this.format_d(value);
                    break;
                }
                default: {
                    throw IntegerFormatter.unknownFormat(this.spec.type, "integer");
                }
            }
            if (this.spec.grouping) {
                this.groupDigits(3, ',');
            }
            return this;
        }
        catch (OutOfMemoryError eme) {
            throw IntegerFormatter.precisionTooLarge("integer");
        }
    }

    void format_d(int value) {
        String number;
        if (value < 0) {
            this.negativeSign(null);
            number = value == Integer.MIN_VALUE ? "2147483648" : Integer.toString(-value);
        } else {
            this.positiveSign(null);
            number = Integer.toString(value);
        }
        this.appendNumber(number);
    }

    void format_x(int value, boolean upper) {
        String number;
        String base2;
        String string2 = base2 = upper ? "0X" : "0x";
        if (value < 0) {
            this.negativeSign(base2);
            number = Integer.toHexString(-value);
        } else {
            this.positiveSign(base2);
            number = Integer.toHexString(value);
        }
        if (upper) {
            number = number.toUpperCase();
        }
        this.appendNumber(number);
    }

    void format_o(int value) {
        String number;
        String base2 = "0o";
        if (value < 0) {
            this.negativeSign(base2);
            number = Integer.toOctalString(-value);
        } else {
            this.positiveSign(base2);
            number = Integer.toOctalString(value);
        }
        this.appendNumber(number);
    }

    void format_b(int value) {
        String number;
        String base2 = "0b";
        if (value < 0) {
            this.negativeSign(base2);
            number = Integer.toBinaryString(-value);
        } else {
            this.positiveSign(base2);
            number = Integer.toBinaryString(value);
        }
        this.appendNumber(number);
    }

    void format_c(int value) {
        int limit;
        int n = limit = this.bytes ? 256 : 0x110000;
        if (value < 0 || value >= limit) {
            throw Py.OverflowError("%c arg not in range(0x" + Integer.toHexString(limit) + ")");
        }
        this.result.appendCodePoint(value);
    }

    final void positiveSign(String base2) {
        char sign = this.spec.sign;
        if (InternalFormat.Spec.specified(sign) && sign != '-') {
            this.append(sign);
            this.lenSign = 1;
        }
        if (base2 != null && this.spec.alternate) {
            this.append(base2);
            this.lenSign += base2.length();
        }
    }

    final void negativeSign(String base2) {
        this.append('-');
        this.lenSign = 1;
        if (base2 != null && this.spec.alternate) {
            this.append(base2);
            this.lenSign += base2.length();
        }
    }

    void appendNumber(String number) {
        this.lenWhole = number.length();
        this.append(number);
    }

    private static final String toHexString(BigInteger value) {
        int signum = value.signum();
        if (signum == 0) {
            return "0";
        }
        byte[] input = value.abs().toByteArray();
        StringBuilder sb = new StringBuilder(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            int b = input[i] & 0xFF;
            sb.append(LOOKUP.charAt(b >> 4));
            sb.append(LOOKUP.charAt(b & 0xF));
        }
        String result2 = sb.toString().replaceFirst("^0+(?!$)", "");
        return signum < 0 ? "-" + result2 : result2;
    }

    private static final String toOctalString(BigInteger value) {
        int signum = value.signum();
        if (signum == 0) {
            return "0";
        }
        byte[] input = value.abs().toByteArray();
        if (input.length < 3) {
            return value.toString(8);
        }
        StringBuilder sb = new StringBuilder(input.length * 3);
        for (int i = input.length - 1; i >= 0; i -= 3) {
            int trip3 = input[i] & 0xFF;
            int trip2 = i - 1 >= 0 ? input[i - 1] & 0xFF : 0;
            int trip1 = i - 2 >= 0 ? input[i - 2] & 0xFF : 0;
            int threebytes = trip3 | trip2 << 8 | trip1 << 16;
            for (int j = 0; j < 8; ++j) {
                sb.append(LOOKUP.charAt(threebytes >> j * 3 & 7));
            }
        }
        String result2 = sb.reverse().toString().replaceFirst("^0+(?!%)", "");
        return signum < 0 ? "-" + result2 : result2;
    }

    private static final String toBinaryString(BigInteger value) {
        int signum = value.signum();
        if (signum == 0) {
            return "0";
        }
        byte[] input = value.abs().toByteArray();
        StringBuilder sb = new StringBuilder(value.bitCount());
        for (int i = 0; i < input.length; ++i) {
            int b = input[i] & 0xFF;
            for (int bit = 7; bit >= 0; --bit) {
                sb.append((b >> bit & 1) > 0 ? "1" : "0");
            }
        }
        String result2 = sb.toString().replaceFirst("^0+(?!$)", "");
        return signum < 0 ? "-" + result2 : result2;
    }

    public static PyString bin(PyObject number) {
        return IntegerFormatter.formatNumber(number, BIN);
    }

    public static PyString formatNumber(PyObject number, InternalFormat.Spec spec) {
        number = number.__index__();
        IntegerFormatter f = new IntegerFormatter(spec);
        if (number instanceof PyInteger) {
            f.format(((PyInteger)number).getValue());
        } else {
            f.format(((PyLong)number).getValue());
        }
        return new PyString(f.getResult());
    }

    public static class Traditional
    extends IntegerFormatter {
        public Traditional(StringBuilder result2, InternalFormat.Spec spec) {
            super(result2, spec);
        }

        public Traditional(InternalFormat.Spec spec) {
            this(new StringBuilder(), spec);
        }

        @Override
        void format_o(BigInteger value) {
            String number;
            int signum = value.signum();
            if (signum < 0) {
                this.negativeSign(null);
                number = IntegerFormatter.toOctalString(value.negate());
            } else {
                this.positiveSign(null);
                number = IntegerFormatter.toOctalString(value);
            }
            this.appendOctalNumber(number);
        }

        @Override
        void format_c(BigInteger value) {
            BigInteger limit;
            if (value.signum() < 0) {
                throw Py.OverflowError("unsigned byte integer is less than minimum");
            }
            BigInteger bigInteger = limit = this.bytes ? LIMIT_BYTE : LIMIT_UNICODE;
            if (value.compareTo(limit) >= 0) {
                throw Py.OverflowError("unsigned byte integer is greater than maximum");
            }
            this.result.appendCodePoint(value.intValue());
        }

        @Override
        void format_o(int value) {
            String number;
            if (value < 0) {
                this.negativeSign(null);
                number = Integer.toOctalString(-value);
            } else {
                this.positiveSign(null);
                number = Integer.toOctalString(value);
            }
            this.appendOctalNumber(number);
        }

        @Override
        void format_c(int value) {
            int limit;
            if (value < 0) {
                throw Py.OverflowError("unsigned byte integer is less than minimum");
            }
            int n = limit = this.bytes ? 256 : 0x110000;
            if (value >= limit) {
                throw Py.OverflowError("unsigned byte integer is greater than maximum");
            }
            this.result.appendCodePoint(value);
        }

        @Override
        void appendNumber(String number) {
            int n;
            int p = this.spec.getPrecision(0);
            for (n = number.length(); n < p; ++n) {
                this.result.append('0');
            }
            this.lenWhole = n;
            this.append(number);
        }

        void appendOctalNumber(String number) {
            int n = number.length();
            int p = this.spec.getPrecision(0);
            if (this.spec.alternate && number.charAt(0) != '0' && n >= p) {
                p = n + 1;
            }
            while (n < p) {
                this.result.append('0');
                ++n;
            }
            this.lenWhole = n;
            this.append(number);
        }
    }
}

