/*
 * Decompiled with CFR 0.152.
 */
package org.python27.core.stringlib;

import org.python27.core.stringlib.InternalFormat;

public class TextFormatter
extends InternalFormat.Formatter {
    public TextFormatter(StringBuilder result2, InternalFormat.Spec spec) {
        super(result2, spec);
    }

    public TextFormatter(InternalFormat.Spec spec) {
        this(new StringBuilder(), spec);
    }

    @Override
    public TextFormatter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public TextFormatter append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    @Override
    public TextFormatter append(CharSequence csq, int start, int end) throws IndexOutOfBoundsException {
        super.append(csq, start, end);
        return this;
    }

    public TextFormatter format(String value) {
        this.setStart();
        int p = this.spec.precision;
        int n = value.length();
        if (InternalFormat.Spec.specified(p) && p < n) {
            int space = Math.max(this.spec.width, p);
            this.result.ensureCapacity(this.result.length() + space + (this.bytes ? 0 : space / 4));
            int count2 = 0;
            while (count2 < p) {
                char c = value.charAt(count2++);
                this.result.append(c);
                if (!Character.isHighSurrogate(c) || p >= n) continue;
                ++p;
            }
            this.lenWhole = count2;
        } else {
            this.lenWhole = n;
            this.result.append(value);
        }
        return this;
    }

    @Override
    public TextFormatter pad() {
        int n = this.spec.width - this.result.codePointCount(this.mark, this.result.length());
        if (n > 0) {
            this.pad(this.mark, n);
        }
        return this;
    }
}

