/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.impl;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import org.python27.icu.impl.ICUResourceBundle;
import org.python27.icu.impl.UResource;
import org.python27.icu.util.ULocale;
import org.python27.icu.util.UResourceBundle;

public final class CalendarUtil {
    private static final String CALKEY = "calendar";
    private static final String DEFCAL = "gregorian";

    public static String getCalendarType(ULocale loc) {
        String calType = loc.getKeywordValue(CALKEY);
        if (calType != null) {
            return calType;
        }
        ULocale canonical = ULocale.createCanonical(loc.toString());
        calType = canonical.getKeywordValue(CALKEY);
        if (calType != null) {
            return calType;
        }
        String region = ULocale.getRegionForSupplementalData(canonical, true);
        return CalendarPreferences.INSTANCE.getCalendarTypeForRegion(region);
    }

    private static final class CalendarPreferences
    extends UResource.Sink {
        private static final CalendarPreferences INSTANCE = new CalendarPreferences();
        Map<String, String> prefs = new TreeMap<String, String>();

        CalendarPreferences() {
            try {
                ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python27/icu/impl/data/icudt59b", "supplementalData");
                rb.getAllItemsWithFallback("calendarPreferenceData", this);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }

        String getCalendarTypeForRegion(String region) {
            String type = this.prefs.get(region);
            return type == null ? CalendarUtil.DEFCAL : type;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table calendarPreferenceData = value.getTable();
            int i = 0;
            while (calendarPreferenceData.getKeyAndValue(i, key, value)) {
                String type;
                UResource.Array types2 = value.getArray();
                if (types2.getValue(0, value) && !(type = value.getString()).equals(CalendarUtil.DEFCAL)) {
                    this.prefs.put(key.toString(), type);
                }
                ++i;
            }
        }
    }
}

