/*
 * Decompiled with CFR 0.152.
 */
package org.python27.icu.impl.duration;

import org.python27.icu.impl.duration.BasicPeriodBuilderFactory;
import org.python27.icu.impl.duration.Period;
import org.python27.icu.impl.duration.PeriodBuilder;
import org.python27.icu.impl.duration.PeriodBuilderImpl;
import org.python27.icu.impl.duration.TimeUnit;

class MultiUnitBuilder
extends PeriodBuilderImpl {
    private int nPeriods;

    MultiUnitBuilder(int nPeriods, BasicPeriodBuilderFactory.Settings settings) {
        super(settings);
        this.nPeriods = nPeriods;
    }

    public static MultiUnitBuilder get(int nPeriods, BasicPeriodBuilderFactory.Settings settings) {
        if (nPeriods > 0 && settings != null) {
            return new MultiUnitBuilder(nPeriods, settings);
        }
        return null;
    }

    @Override
    protected PeriodBuilder withSettings(BasicPeriodBuilderFactory.Settings settingsToUse) {
        return MultiUnitBuilder.get(this.nPeriods, settingsToUse);
    }

    @Override
    protected Period handleCreate(long duration, long referenceDate, boolean inPast) {
        Period period = null;
        int n = 0;
        short uset = this.settings.effectiveSet();
        for (int i = 0; i < TimeUnit.units.length; ++i) {
            if (0 == (uset & 1 << i)) continue;
            TimeUnit unit = TimeUnit.units[i];
            if (n == this.nPeriods) break;
            long unitDuration = this.approximateDurationOf(unit);
            if (duration < unitDuration && n <= 0) continue;
            double count2 = (double)duration / (double)unitDuration;
            if (++n < this.nPeriods) {
                count2 = Math.floor(count2);
                duration -= (long)(count2 * (double)unitDuration);
            }
            period = period == null ? Period.at((float)count2, unit).inPast(inPast) : period.and((float)count2, unit);
        }
        return period;
    }
}

